/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class EncryptionTransitionRequest
implements JsonSerializable<EncryptionTransitionRequest> {
    private String virtualNetworkId;
    private String privateEndpointId;
    private static final ClientLogger LOGGER = new ClientLogger(EncryptionTransitionRequest.class);

    public String virtualNetworkId() {
        return this.virtualNetworkId;
    }

    public EncryptionTransitionRequest withVirtualNetworkId(String virtualNetworkId) {
        this.virtualNetworkId = virtualNetworkId;
        return this;
    }

    public String privateEndpointId() {
        return this.privateEndpointId;
    }

    public EncryptionTransitionRequest withPrivateEndpointId(String privateEndpointId) {
        this.privateEndpointId = privateEndpointId;
        return this;
    }

    public void validate() {
        if (this.virtualNetworkId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property virtualNetworkId in model EncryptionTransitionRequest"));
        }
        if (this.privateEndpointId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property privateEndpointId in model EncryptionTransitionRequest"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("virtualNetworkId", this.virtualNetworkId);
        jsonWriter.writeStringField("privateEndpointId", this.privateEndpointId);
        return jsonWriter.writeEndObject();
    }

    public static EncryptionTransitionRequest fromJson(JsonReader jsonReader) throws IOException {
        return (EncryptionTransitionRequest)jsonReader.readObject(reader -> {
            EncryptionTransitionRequest deserializedEncryptionTransitionRequest = new EncryptionTransitionRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("virtualNetworkId".equals(fieldName)) {
                    deserializedEncryptionTransitionRequest.virtualNetworkId = reader.getString();
                    continue;
                }
                if ("privateEndpointId".equals(fieldName)) {
                    deserializedEncryptionTransitionRequest.privateEndpointId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEncryptionTransitionRequest;
        });
    }
}

