/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.ElasticExportPolicy;
import com.azure.resourcemanager.netapp.models.ElasticSmbPatchProperties;
import com.azure.resourcemanager.netapp.models.ElasticVolumeDataProtectionPatchProperties;
import com.azure.resourcemanager.netapp.models.SnapshotDirectoryVisibility;
import java.io.IOException;

public final class ElasticVolumeUpdateProperties
implements JsonSerializable<ElasticVolumeUpdateProperties> {
    private Long size;
    private ElasticExportPolicy exportPolicy;
    private ElasticVolumeDataProtectionPatchProperties dataProtection;
    private SnapshotDirectoryVisibility snapshotDirectoryVisibility;
    private ElasticSmbPatchProperties smbProperties;

    public Long size() {
        return this.size;
    }

    public ElasticVolumeUpdateProperties withSize(Long size) {
        this.size = size;
        return this;
    }

    public ElasticExportPolicy exportPolicy() {
        return this.exportPolicy;
    }

    public ElasticVolumeUpdateProperties withExportPolicy(ElasticExportPolicy exportPolicy) {
        this.exportPolicy = exportPolicy;
        return this;
    }

    public ElasticVolumeDataProtectionPatchProperties dataProtection() {
        return this.dataProtection;
    }

    public ElasticVolumeUpdateProperties withDataProtection(ElasticVolumeDataProtectionPatchProperties dataProtection) {
        this.dataProtection = dataProtection;
        return this;
    }

    public SnapshotDirectoryVisibility snapshotDirectoryVisibility() {
        return this.snapshotDirectoryVisibility;
    }

    public ElasticVolumeUpdateProperties withSnapshotDirectoryVisibility(SnapshotDirectoryVisibility snapshotDirectoryVisibility) {
        this.snapshotDirectoryVisibility = snapshotDirectoryVisibility;
        return this;
    }

    public ElasticSmbPatchProperties smbProperties() {
        return this.smbProperties;
    }

    public ElasticVolumeUpdateProperties withSmbProperties(ElasticSmbPatchProperties smbProperties) {
        this.smbProperties = smbProperties;
        return this;
    }

    public void validate() {
        if (this.exportPolicy() != null) {
            this.exportPolicy().validate();
        }
        if (this.dataProtection() != null) {
            this.dataProtection().validate();
        }
        if (this.smbProperties() != null) {
            this.smbProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("size", (Number)this.size);
        jsonWriter.writeJsonField("exportPolicy", (JsonSerializable)this.exportPolicy);
        jsonWriter.writeJsonField("dataProtection", (JsonSerializable)this.dataProtection);
        jsonWriter.writeStringField("snapshotDirectoryVisibility", this.snapshotDirectoryVisibility == null ? null : this.snapshotDirectoryVisibility.toString());
        jsonWriter.writeJsonField("smbProperties", (JsonSerializable)this.smbProperties);
        return jsonWriter.writeEndObject();
    }

    public static ElasticVolumeUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticVolumeUpdateProperties)jsonReader.readObject(reader -> {
            ElasticVolumeUpdateProperties deserializedElasticVolumeUpdateProperties = new ElasticVolumeUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("size".equals(fieldName)) {
                    deserializedElasticVolumeUpdateProperties.size = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("exportPolicy".equals(fieldName)) {
                    deserializedElasticVolumeUpdateProperties.exportPolicy = ElasticExportPolicy.fromJson(reader);
                    continue;
                }
                if ("dataProtection".equals(fieldName)) {
                    deserializedElasticVolumeUpdateProperties.dataProtection = ElasticVolumeDataProtectionPatchProperties.fromJson(reader);
                    continue;
                }
                if ("snapshotDirectoryVisibility".equals(fieldName)) {
                    deserializedElasticVolumeUpdateProperties.snapshotDirectoryVisibility = SnapshotDirectoryVisibility.fromString(reader.getString());
                    continue;
                }
                if ("smbProperties".equals(fieldName)) {
                    deserializedElasticVolumeUpdateProperties.smbProperties = ElasticSmbPatchProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticVolumeUpdateProperties;
        });
    }
}

