/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.ElasticExportPolicy;
import com.azure.resourcemanager.netapp.models.ElasticMountTargetProperties;
import com.azure.resourcemanager.netapp.models.ElasticProtocolType;
import com.azure.resourcemanager.netapp.models.ElasticResourceAvailabilityStatus;
import com.azure.resourcemanager.netapp.models.ElasticSmbProperties;
import com.azure.resourcemanager.netapp.models.ElasticVolumeDataProtectionProperties;
import com.azure.resourcemanager.netapp.models.ElasticVolumeRestorationState;
import com.azure.resourcemanager.netapp.models.ProvisioningState;
import com.azure.resourcemanager.netapp.models.SnapshotDirectoryVisibility;
import java.io.IOException;
import java.util.List;

public final class ElasticVolumeProperties
implements JsonSerializable<ElasticVolumeProperties> {
    private String filePath;
    private long size;
    private ElasticExportPolicy exportPolicy;
    private List<ElasticProtocolType> protocolTypes;
    private ProvisioningState provisioningState;
    private ElasticResourceAvailabilityStatus availabilityStatus;
    private String snapshotResourceId;
    private List<ElasticMountTargetProperties> mountTargets;
    private ElasticVolumeDataProtectionProperties dataProtection;
    private SnapshotDirectoryVisibility snapshotDirectoryVisibility;
    private ElasticSmbProperties smbProperties;
    private String backupResourceId;
    private ElasticVolumeRestorationState restorationState;
    private static final ClientLogger LOGGER = new ClientLogger(ElasticVolumeProperties.class);

    public String filePath() {
        return this.filePath;
    }

    public ElasticVolumeProperties withFilePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    public long size() {
        return this.size;
    }

    public ElasticVolumeProperties withSize(long size) {
        this.size = size;
        return this;
    }

    public ElasticExportPolicy exportPolicy() {
        return this.exportPolicy;
    }

    public ElasticVolumeProperties withExportPolicy(ElasticExportPolicy exportPolicy) {
        this.exportPolicy = exportPolicy;
        return this;
    }

    public List<ElasticProtocolType> protocolTypes() {
        return this.protocolTypes;
    }

    public ElasticVolumeProperties withProtocolTypes(List<ElasticProtocolType> protocolTypes) {
        this.protocolTypes = protocolTypes;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ElasticResourceAvailabilityStatus availabilityStatus() {
        return this.availabilityStatus;
    }

    public String snapshotResourceId() {
        return this.snapshotResourceId;
    }

    public ElasticVolumeProperties withSnapshotResourceId(String snapshotResourceId) {
        this.snapshotResourceId = snapshotResourceId;
        return this;
    }

    public List<ElasticMountTargetProperties> mountTargets() {
        return this.mountTargets;
    }

    public ElasticVolumeDataProtectionProperties dataProtection() {
        return this.dataProtection;
    }

    public ElasticVolumeProperties withDataProtection(ElasticVolumeDataProtectionProperties dataProtection) {
        this.dataProtection = dataProtection;
        return this;
    }

    public SnapshotDirectoryVisibility snapshotDirectoryVisibility() {
        return this.snapshotDirectoryVisibility;
    }

    public ElasticVolumeProperties withSnapshotDirectoryVisibility(SnapshotDirectoryVisibility snapshotDirectoryVisibility) {
        this.snapshotDirectoryVisibility = snapshotDirectoryVisibility;
        return this;
    }

    public ElasticSmbProperties smbProperties() {
        return this.smbProperties;
    }

    public ElasticVolumeProperties withSmbProperties(ElasticSmbProperties smbProperties) {
        this.smbProperties = smbProperties;
        return this;
    }

    public String backupResourceId() {
        return this.backupResourceId;
    }

    public ElasticVolumeProperties withBackupResourceId(String backupResourceId) {
        this.backupResourceId = backupResourceId;
        return this;
    }

    public ElasticVolumeRestorationState restorationState() {
        return this.restorationState;
    }

    public void validate() {
        if (this.filePath() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property filePath in model ElasticVolumeProperties"));
        }
        if (this.exportPolicy() != null) {
            this.exportPolicy().validate();
        }
        if (this.protocolTypes() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property protocolTypes in model ElasticVolumeProperties"));
        }
        if (this.mountTargets() != null) {
            this.mountTargets().forEach(e -> e.validate());
        }
        if (this.dataProtection() != null) {
            this.dataProtection().validate();
        }
        if (this.smbProperties() != null) {
            this.smbProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("filePath", this.filePath);
        jsonWriter.writeLongField("size", this.size);
        jsonWriter.writeArrayField("protocolTypes", this.protocolTypes, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeJsonField("exportPolicy", (JsonSerializable)this.exportPolicy);
        jsonWriter.writeStringField("snapshotResourceId", this.snapshotResourceId);
        jsonWriter.writeJsonField("dataProtection", (JsonSerializable)this.dataProtection);
        jsonWriter.writeStringField("snapshotDirectoryVisibility", this.snapshotDirectoryVisibility == null ? null : this.snapshotDirectoryVisibility.toString());
        jsonWriter.writeJsonField("smbProperties", (JsonSerializable)this.smbProperties);
        jsonWriter.writeStringField("backupResourceId", this.backupResourceId);
        return jsonWriter.writeEndObject();
    }

    public static ElasticVolumeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticVolumeProperties)jsonReader.readObject(reader -> {
            ElasticVolumeProperties deserializedElasticVolumeProperties = new ElasticVolumeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("filePath".equals(fieldName)) {
                    deserializedElasticVolumeProperties.filePath = reader.getString();
                    continue;
                }
                if ("size".equals(fieldName)) {
                    deserializedElasticVolumeProperties.size = reader.getLong();
                    continue;
                }
                if ("protocolTypes".equals(fieldName)) {
                    List protocolTypes;
                    deserializedElasticVolumeProperties.protocolTypes = protocolTypes = reader.readArray(reader1 -> ElasticProtocolType.fromString(reader1.getString()));
                    continue;
                }
                if ("exportPolicy".equals(fieldName)) {
                    deserializedElasticVolumeProperties.exportPolicy = ElasticExportPolicy.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedElasticVolumeProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("availabilityStatus".equals(fieldName)) {
                    deserializedElasticVolumeProperties.availabilityStatus = ElasticResourceAvailabilityStatus.fromString(reader.getString());
                    continue;
                }
                if ("snapshotResourceId".equals(fieldName)) {
                    deserializedElasticVolumeProperties.snapshotResourceId = reader.getString();
                    continue;
                }
                if ("mountTargets".equals(fieldName)) {
                    List mountTargets;
                    deserializedElasticVolumeProperties.mountTargets = mountTargets = reader.readArray(reader1 -> ElasticMountTargetProperties.fromJson(reader1));
                    continue;
                }
                if ("dataProtection".equals(fieldName)) {
                    deserializedElasticVolumeProperties.dataProtection = ElasticVolumeDataProtectionProperties.fromJson(reader);
                    continue;
                }
                if ("snapshotDirectoryVisibility".equals(fieldName)) {
                    deserializedElasticVolumeProperties.snapshotDirectoryVisibility = SnapshotDirectoryVisibility.fromString(reader.getString());
                    continue;
                }
                if ("smbProperties".equals(fieldName)) {
                    deserializedElasticVolumeProperties.smbProperties = ElasticSmbProperties.fromJson(reader);
                    continue;
                }
                if ("backupResourceId".equals(fieldName)) {
                    deserializedElasticVolumeProperties.backupResourceId = reader.getString();
                    continue;
                }
                if ("restorationState".equals(fieldName)) {
                    deserializedElasticVolumeProperties.restorationState = ElasticVolumeRestorationState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticVolumeProperties;
        });
    }
}

