/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.ElasticVolumeBackupProperties;
import com.azure.resourcemanager.netapp.models.ElasticVolumeSnapshotProperties;
import java.io.IOException;

public final class ElasticVolumeDataProtectionProperties
implements JsonSerializable<ElasticVolumeDataProtectionProperties> {
    private ElasticVolumeSnapshotProperties snapshot;
    private ElasticVolumeBackupProperties backup;

    public ElasticVolumeSnapshotProperties snapshot() {
        return this.snapshot;
    }

    public ElasticVolumeDataProtectionProperties withSnapshot(ElasticVolumeSnapshotProperties snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public ElasticVolumeBackupProperties backup() {
        return this.backup;
    }

    public ElasticVolumeDataProtectionProperties withBackup(ElasticVolumeBackupProperties backup) {
        this.backup = backup;
        return this;
    }

    public void validate() {
        if (this.snapshot() != null) {
            this.snapshot().validate();
        }
        if (this.backup() != null) {
            this.backup().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("snapshot", (JsonSerializable)this.snapshot);
        jsonWriter.writeJsonField("backup", (JsonSerializable)this.backup);
        return jsonWriter.writeEndObject();
    }

    public static ElasticVolumeDataProtectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticVolumeDataProtectionProperties)jsonReader.readObject(reader -> {
            ElasticVolumeDataProtectionProperties deserializedElasticVolumeDataProtectionProperties = new ElasticVolumeDataProtectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("snapshot".equals(fieldName)) {
                    deserializedElasticVolumeDataProtectionProperties.snapshot = ElasticVolumeSnapshotProperties.fromJson(reader);
                    continue;
                }
                if ("backup".equals(fieldName)) {
                    deserializedElasticVolumeDataProtectionProperties.backup = ElasticVolumeBackupProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticVolumeDataProtectionProperties;
        });
    }
}

