/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.DayOfWeek;
import java.io.IOException;
import java.util.List;

public final class ElasticSnapshotPolicyWeeklySchedule
implements JsonSerializable<ElasticSnapshotPolicyWeeklySchedule> {
    private Integer snapshotsToKeep;
    private List<DayOfWeek> days;
    private Integer hour;
    private Integer minute;

    public Integer snapshotsToKeep() {
        return this.snapshotsToKeep;
    }

    public ElasticSnapshotPolicyWeeklySchedule withSnapshotsToKeep(Integer snapshotsToKeep) {
        this.snapshotsToKeep = snapshotsToKeep;
        return this;
    }

    public List<DayOfWeek> days() {
        return this.days;
    }

    public ElasticSnapshotPolicyWeeklySchedule withDays(List<DayOfWeek> days) {
        this.days = days;
        return this;
    }

    public Integer hour() {
        return this.hour;
    }

    public ElasticSnapshotPolicyWeeklySchedule withHour(Integer hour) {
        this.hour = hour;
        return this;
    }

    public Integer minute() {
        return this.minute;
    }

    public ElasticSnapshotPolicyWeeklySchedule withMinute(Integer minute) {
        this.minute = minute;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("snapshotsToKeep", (Number)this.snapshotsToKeep);
        jsonWriter.writeArrayField("days", this.days, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeNumberField("hour", (Number)this.hour);
        jsonWriter.writeNumberField("minute", (Number)this.minute);
        return jsonWriter.writeEndObject();
    }

    public static ElasticSnapshotPolicyWeeklySchedule fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticSnapshotPolicyWeeklySchedule)jsonReader.readObject(reader -> {
            ElasticSnapshotPolicyWeeklySchedule deserializedElasticSnapshotPolicyWeeklySchedule = new ElasticSnapshotPolicyWeeklySchedule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("snapshotsToKeep".equals(fieldName)) {
                    deserializedElasticSnapshotPolicyWeeklySchedule.snapshotsToKeep = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("days".equals(fieldName)) {
                    List days;
                    deserializedElasticSnapshotPolicyWeeklySchedule.days = days = reader.readArray(reader1 -> DayOfWeek.fromString(reader1.getString()));
                    continue;
                }
                if ("hour".equals(fieldName)) {
                    deserializedElasticSnapshotPolicyWeeklySchedule.hour = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("minute".equals(fieldName)) {
                    deserializedElasticSnapshotPolicyWeeklySchedule.minute = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticSnapshotPolicyWeeklySchedule;
        });
    }
}

