/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.ElasticSnapshotPolicyDailySchedule;
import com.azure.resourcemanager.netapp.models.ElasticSnapshotPolicyHourlySchedule;
import com.azure.resourcemanager.netapp.models.ElasticSnapshotPolicyMonthlySchedule;
import com.azure.resourcemanager.netapp.models.ElasticSnapshotPolicyWeeklySchedule;
import com.azure.resourcemanager.netapp.models.PolicyStatus;
import java.io.IOException;

public final class ElasticSnapshotPolicyUpdateProperties
implements JsonSerializable<ElasticSnapshotPolicyUpdateProperties> {
    private ElasticSnapshotPolicyHourlySchedule hourlySchedule;
    private ElasticSnapshotPolicyDailySchedule dailySchedule;
    private ElasticSnapshotPolicyWeeklySchedule weeklySchedule;
    private ElasticSnapshotPolicyMonthlySchedule monthlySchedule;
    private PolicyStatus policyStatus;

    public ElasticSnapshotPolicyHourlySchedule hourlySchedule() {
        return this.hourlySchedule;
    }

    public ElasticSnapshotPolicyUpdateProperties withHourlySchedule(ElasticSnapshotPolicyHourlySchedule hourlySchedule) {
        this.hourlySchedule = hourlySchedule;
        return this;
    }

    public ElasticSnapshotPolicyDailySchedule dailySchedule() {
        return this.dailySchedule;
    }

    public ElasticSnapshotPolicyUpdateProperties withDailySchedule(ElasticSnapshotPolicyDailySchedule dailySchedule) {
        this.dailySchedule = dailySchedule;
        return this;
    }

    public ElasticSnapshotPolicyWeeklySchedule weeklySchedule() {
        return this.weeklySchedule;
    }

    public ElasticSnapshotPolicyUpdateProperties withWeeklySchedule(ElasticSnapshotPolicyWeeklySchedule weeklySchedule) {
        this.weeklySchedule = weeklySchedule;
        return this;
    }

    public ElasticSnapshotPolicyMonthlySchedule monthlySchedule() {
        return this.monthlySchedule;
    }

    public ElasticSnapshotPolicyUpdateProperties withMonthlySchedule(ElasticSnapshotPolicyMonthlySchedule monthlySchedule) {
        this.monthlySchedule = monthlySchedule;
        return this;
    }

    public PolicyStatus policyStatus() {
        return this.policyStatus;
    }

    public ElasticSnapshotPolicyUpdateProperties withPolicyStatus(PolicyStatus policyStatus) {
        this.policyStatus = policyStatus;
        return this;
    }

    public void validate() {
        if (this.hourlySchedule() != null) {
            this.hourlySchedule().validate();
        }
        if (this.dailySchedule() != null) {
            this.dailySchedule().validate();
        }
        if (this.weeklySchedule() != null) {
            this.weeklySchedule().validate();
        }
        if (this.monthlySchedule() != null) {
            this.monthlySchedule().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("hourlySchedule", (JsonSerializable)this.hourlySchedule);
        jsonWriter.writeJsonField("dailySchedule", (JsonSerializable)this.dailySchedule);
        jsonWriter.writeJsonField("weeklySchedule", (JsonSerializable)this.weeklySchedule);
        jsonWriter.writeJsonField("monthlySchedule", (JsonSerializable)this.monthlySchedule);
        jsonWriter.writeStringField("policyStatus", this.policyStatus == null ? null : this.policyStatus.toString());
        return jsonWriter.writeEndObject();
    }

    public static ElasticSnapshotPolicyUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticSnapshotPolicyUpdateProperties)jsonReader.readObject(reader -> {
            ElasticSnapshotPolicyUpdateProperties deserializedElasticSnapshotPolicyUpdateProperties = new ElasticSnapshotPolicyUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("hourlySchedule".equals(fieldName)) {
                    deserializedElasticSnapshotPolicyUpdateProperties.hourlySchedule = ElasticSnapshotPolicyHourlySchedule.fromJson(reader);
                    continue;
                }
                if ("dailySchedule".equals(fieldName)) {
                    deserializedElasticSnapshotPolicyUpdateProperties.dailySchedule = ElasticSnapshotPolicyDailySchedule.fromJson(reader);
                    continue;
                }
                if ("weeklySchedule".equals(fieldName)) {
                    deserializedElasticSnapshotPolicyUpdateProperties.weeklySchedule = ElasticSnapshotPolicyWeeklySchedule.fromJson(reader);
                    continue;
                }
                if ("monthlySchedule".equals(fieldName)) {
                    deserializedElasticSnapshotPolicyUpdateProperties.monthlySchedule = ElasticSnapshotPolicyMonthlySchedule.fromJson(reader);
                    continue;
                }
                if ("policyStatus".equals(fieldName)) {
                    deserializedElasticSnapshotPolicyUpdateProperties.policyStatus = PolicyStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticSnapshotPolicyUpdateProperties;
        });
    }
}

