/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.ElasticSnapshotPolicyDailySchedule;
import com.azure.resourcemanager.netapp.models.ElasticSnapshotPolicyHourlySchedule;
import com.azure.resourcemanager.netapp.models.ElasticSnapshotPolicyMonthlySchedule;
import com.azure.resourcemanager.netapp.models.ElasticSnapshotPolicyWeeklySchedule;
import com.azure.resourcemanager.netapp.models.PolicyStatus;
import com.azure.resourcemanager.netapp.models.ProvisioningState;
import java.io.IOException;

public final class ElasticSnapshotPolicyProperties
implements JsonSerializable<ElasticSnapshotPolicyProperties> {
    private ElasticSnapshotPolicyHourlySchedule hourlySchedule;
    private ElasticSnapshotPolicyDailySchedule dailySchedule;
    private ElasticSnapshotPolicyWeeklySchedule weeklySchedule;
    private ElasticSnapshotPolicyMonthlySchedule monthlySchedule;
    private PolicyStatus policyStatus;
    private ProvisioningState provisioningState;

    public ElasticSnapshotPolicyHourlySchedule hourlySchedule() {
        return this.hourlySchedule;
    }

    public ElasticSnapshotPolicyProperties withHourlySchedule(ElasticSnapshotPolicyHourlySchedule hourlySchedule) {
        this.hourlySchedule = hourlySchedule;
        return this;
    }

    public ElasticSnapshotPolicyDailySchedule dailySchedule() {
        return this.dailySchedule;
    }

    public ElasticSnapshotPolicyProperties withDailySchedule(ElasticSnapshotPolicyDailySchedule dailySchedule) {
        this.dailySchedule = dailySchedule;
        return this;
    }

    public ElasticSnapshotPolicyWeeklySchedule weeklySchedule() {
        return this.weeklySchedule;
    }

    public ElasticSnapshotPolicyProperties withWeeklySchedule(ElasticSnapshotPolicyWeeklySchedule weeklySchedule) {
        this.weeklySchedule = weeklySchedule;
        return this;
    }

    public ElasticSnapshotPolicyMonthlySchedule monthlySchedule() {
        return this.monthlySchedule;
    }

    public ElasticSnapshotPolicyProperties withMonthlySchedule(ElasticSnapshotPolicyMonthlySchedule monthlySchedule) {
        this.monthlySchedule = monthlySchedule;
        return this;
    }

    public PolicyStatus policyStatus() {
        return this.policyStatus;
    }

    public ElasticSnapshotPolicyProperties withPolicyStatus(PolicyStatus policyStatus) {
        this.policyStatus = policyStatus;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.hourlySchedule() != null) {
            this.hourlySchedule().validate();
        }
        if (this.dailySchedule() != null) {
            this.dailySchedule().validate();
        }
        if (this.weeklySchedule() != null) {
            this.weeklySchedule().validate();
        }
        if (this.monthlySchedule() != null) {
            this.monthlySchedule().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("hourlySchedule", (JsonSerializable)this.hourlySchedule);
        jsonWriter.writeJsonField("dailySchedule", (JsonSerializable)this.dailySchedule);
        jsonWriter.writeJsonField("weeklySchedule", (JsonSerializable)this.weeklySchedule);
        jsonWriter.writeJsonField("monthlySchedule", (JsonSerializable)this.monthlySchedule);
        jsonWriter.writeStringField("policyStatus", this.policyStatus == null ? null : this.policyStatus.toString());
        return jsonWriter.writeEndObject();
    }

    public static ElasticSnapshotPolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticSnapshotPolicyProperties)jsonReader.readObject(reader -> {
            ElasticSnapshotPolicyProperties deserializedElasticSnapshotPolicyProperties = new ElasticSnapshotPolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("hourlySchedule".equals(fieldName)) {
                    deserializedElasticSnapshotPolicyProperties.hourlySchedule = ElasticSnapshotPolicyHourlySchedule.fromJson(reader);
                    continue;
                }
                if ("dailySchedule".equals(fieldName)) {
                    deserializedElasticSnapshotPolicyProperties.dailySchedule = ElasticSnapshotPolicyDailySchedule.fromJson(reader);
                    continue;
                }
                if ("weeklySchedule".equals(fieldName)) {
                    deserializedElasticSnapshotPolicyProperties.weeklySchedule = ElasticSnapshotPolicyWeeklySchedule.fromJson(reader);
                    continue;
                }
                if ("monthlySchedule".equals(fieldName)) {
                    deserializedElasticSnapshotPolicyProperties.monthlySchedule = ElasticSnapshotPolicyMonthlySchedule.fromJson(reader);
                    continue;
                }
                if ("policyStatus".equals(fieldName)) {
                    deserializedElasticSnapshotPolicyProperties.policyStatus = PolicyStatus.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedElasticSnapshotPolicyProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticSnapshotPolicyProperties;
        });
    }
}

