/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.ElasticKeyVaultStatus;
import java.io.IOException;

public final class ElasticKeyVaultProperties
implements JsonSerializable<ElasticKeyVaultProperties> {
    private String keyVaultUri;
    private String keyName;
    private String keyVaultResourceId;
    private ElasticKeyVaultStatus status;

    public String keyVaultUri() {
        return this.keyVaultUri;
    }

    public ElasticKeyVaultProperties withKeyVaultUri(String keyVaultUri) {
        this.keyVaultUri = keyVaultUri;
        return this;
    }

    public String keyName() {
        return this.keyName;
    }

    public ElasticKeyVaultProperties withKeyName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    public String keyVaultResourceId() {
        return this.keyVaultResourceId;
    }

    public ElasticKeyVaultProperties withKeyVaultResourceId(String keyVaultResourceId) {
        this.keyVaultResourceId = keyVaultResourceId;
        return this;
    }

    public ElasticKeyVaultStatus status() {
        return this.status;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyVaultUri", this.keyVaultUri);
        jsonWriter.writeStringField("keyName", this.keyName);
        jsonWriter.writeStringField("keyVaultResourceId", this.keyVaultResourceId);
        return jsonWriter.writeEndObject();
    }

    public static ElasticKeyVaultProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticKeyVaultProperties)jsonReader.readObject(reader -> {
            ElasticKeyVaultProperties deserializedElasticKeyVaultProperties = new ElasticKeyVaultProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyVaultUri".equals(fieldName)) {
                    deserializedElasticKeyVaultProperties.keyVaultUri = reader.getString();
                    continue;
                }
                if ("keyName".equals(fieldName)) {
                    deserializedElasticKeyVaultProperties.keyName = reader.getString();
                    continue;
                }
                if ("keyVaultResourceId".equals(fieldName)) {
                    deserializedElasticKeyVaultProperties.keyVaultResourceId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedElasticKeyVaultProperties.status = ElasticKeyVaultStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticKeyVaultProperties;
        });
    }
}

