/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.ElasticNfsv3Access;
import com.azure.resourcemanager.netapp.models.ElasticNfsv4Access;
import com.azure.resourcemanager.netapp.models.ElasticRootAccess;
import com.azure.resourcemanager.netapp.models.ElasticUnixAccessRule;
import java.io.IOException;
import java.util.List;

public final class ElasticExportPolicyRule
implements JsonSerializable<ElasticExportPolicyRule> {
    private Integer ruleIndex;
    private ElasticUnixAccessRule unixAccessRule;
    private ElasticNfsv3Access nfsv3;
    private ElasticNfsv4Access nfsv4;
    private List<String> allowedClients;
    private ElasticRootAccess rootAccess;

    public Integer ruleIndex() {
        return this.ruleIndex;
    }

    public ElasticExportPolicyRule withRuleIndex(Integer ruleIndex) {
        this.ruleIndex = ruleIndex;
        return this;
    }

    public ElasticUnixAccessRule unixAccessRule() {
        return this.unixAccessRule;
    }

    public ElasticExportPolicyRule withUnixAccessRule(ElasticUnixAccessRule unixAccessRule) {
        this.unixAccessRule = unixAccessRule;
        return this;
    }

    public ElasticNfsv3Access nfsv3() {
        return this.nfsv3;
    }

    public ElasticExportPolicyRule withNfsv3(ElasticNfsv3Access nfsv3) {
        this.nfsv3 = nfsv3;
        return this;
    }

    public ElasticNfsv4Access nfsv4() {
        return this.nfsv4;
    }

    public ElasticExportPolicyRule withNfsv4(ElasticNfsv4Access nfsv4) {
        this.nfsv4 = nfsv4;
        return this;
    }

    public List<String> allowedClients() {
        return this.allowedClients;
    }

    public ElasticExportPolicyRule withAllowedClients(List<String> allowedClients) {
        this.allowedClients = allowedClients;
        return this;
    }

    public ElasticRootAccess rootAccess() {
        return this.rootAccess;
    }

    public ElasticExportPolicyRule withRootAccess(ElasticRootAccess rootAccess) {
        this.rootAccess = rootAccess;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("ruleIndex", (Number)this.ruleIndex);
        jsonWriter.writeStringField("unixAccessRule", this.unixAccessRule == null ? null : this.unixAccessRule.toString());
        jsonWriter.writeStringField("nfsv3", this.nfsv3 == null ? null : this.nfsv3.toString());
        jsonWriter.writeStringField("nfsv4", this.nfsv4 == null ? null : this.nfsv4.toString());
        jsonWriter.writeArrayField("allowedClients", this.allowedClients, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("rootAccess", this.rootAccess == null ? null : this.rootAccess.toString());
        return jsonWriter.writeEndObject();
    }

    public static ElasticExportPolicyRule fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticExportPolicyRule)jsonReader.readObject(reader -> {
            ElasticExportPolicyRule deserializedElasticExportPolicyRule = new ElasticExportPolicyRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ruleIndex".equals(fieldName)) {
                    deserializedElasticExportPolicyRule.ruleIndex = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("unixAccessRule".equals(fieldName)) {
                    deserializedElasticExportPolicyRule.unixAccessRule = ElasticUnixAccessRule.fromString(reader.getString());
                    continue;
                }
                if ("nfsv3".equals(fieldName)) {
                    deserializedElasticExportPolicyRule.nfsv3 = ElasticNfsv3Access.fromString(reader.getString());
                    continue;
                }
                if ("nfsv4".equals(fieldName)) {
                    deserializedElasticExportPolicyRule.nfsv4 = ElasticNfsv4Access.fromString(reader.getString());
                    continue;
                }
                if ("allowedClients".equals(fieldName)) {
                    List allowedClients;
                    deserializedElasticExportPolicyRule.allowedClients = allowedClients = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("rootAccess".equals(fieldName)) {
                    deserializedElasticExportPolicyRule.rootAccess = ElasticRootAccess.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticExportPolicyRule;
        });
    }
}

