/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.ElasticExportPolicyRule;
import java.io.IOException;
import java.util.List;

public final class ElasticExportPolicy
implements JsonSerializable<ElasticExportPolicy> {
    private List<ElasticExportPolicyRule> rules;

    public List<ElasticExportPolicyRule> rules() {
        return this.rules;
    }

    public ElasticExportPolicy withRules(List<ElasticExportPolicyRule> rules) {
        this.rules = rules;
        return this;
    }

    public void validate() {
        if (this.rules() != null) {
            this.rules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ElasticExportPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticExportPolicy)jsonReader.readObject(reader -> {
            ElasticExportPolicy deserializedElasticExportPolicy = new ElasticExportPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("rules".equals(fieldName)) {
                    List rules;
                    deserializedElasticExportPolicy.rules = rules = reader.readArray(reader1 -> ElasticExportPolicyRule.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticExportPolicy;
        });
    }
}

