/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.ElasticPoolEncryptionKeySource;
import java.io.IOException;

public final class ElasticEncryptionConfiguration
implements JsonSerializable<ElasticEncryptionConfiguration> {
    private ElasticPoolEncryptionKeySource elasticPoolEncryptionKeySource;
    private String keyVaultPrivateEndpointResourceId;
    private static final ClientLogger LOGGER = new ClientLogger(ElasticEncryptionConfiguration.class);

    public ElasticPoolEncryptionKeySource elasticPoolEncryptionKeySource() {
        return this.elasticPoolEncryptionKeySource;
    }

    public ElasticEncryptionConfiguration withElasticPoolEncryptionKeySource(ElasticPoolEncryptionKeySource elasticPoolEncryptionKeySource) {
        this.elasticPoolEncryptionKeySource = elasticPoolEncryptionKeySource;
        return this;
    }

    public String keyVaultPrivateEndpointResourceId() {
        return this.keyVaultPrivateEndpointResourceId;
    }

    public ElasticEncryptionConfiguration withKeyVaultPrivateEndpointResourceId(String keyVaultPrivateEndpointResourceId) {
        this.keyVaultPrivateEndpointResourceId = keyVaultPrivateEndpointResourceId;
        return this;
    }

    public void validate() {
        if (this.elasticPoolEncryptionKeySource() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property elasticPoolEncryptionKeySource in model ElasticEncryptionConfiguration"));
        }
        if (this.keyVaultPrivateEndpointResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property keyVaultPrivateEndpointResourceId in model ElasticEncryptionConfiguration"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("elasticPoolEncryptionKeySource", this.elasticPoolEncryptionKeySource == null ? null : this.elasticPoolEncryptionKeySource.toString());
        jsonWriter.writeStringField("keyVaultPrivateEndpointResourceId", this.keyVaultPrivateEndpointResourceId);
        return jsonWriter.writeEndObject();
    }

    public static ElasticEncryptionConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticEncryptionConfiguration)jsonReader.readObject(reader -> {
            ElasticEncryptionConfiguration deserializedElasticEncryptionConfiguration = new ElasticEncryptionConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("elasticPoolEncryptionKeySource".equals(fieldName)) {
                    deserializedElasticEncryptionConfiguration.elasticPoolEncryptionKeySource = ElasticPoolEncryptionKeySource.fromString(reader.getString());
                    continue;
                }
                if ("keyVaultPrivateEndpointResourceId".equals(fieldName)) {
                    deserializedElasticEncryptionConfiguration.keyVaultPrivateEndpointResourceId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticEncryptionConfiguration;
        });
    }
}

