/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.ElasticEncryptionIdentity;
import com.azure.resourcemanager.netapp.models.ElasticKeyVaultProperties;
import com.azure.resourcemanager.netapp.models.KeySource;
import java.io.IOException;

public final class ElasticEncryption
implements JsonSerializable<ElasticEncryption> {
    private KeySource keySource;
    private ElasticKeyVaultProperties keyVaultProperties;
    private ElasticEncryptionIdentity identity;

    public KeySource keySource() {
        return this.keySource;
    }

    public ElasticEncryption withKeySource(KeySource keySource) {
        this.keySource = keySource;
        return this;
    }

    public ElasticKeyVaultProperties keyVaultProperties() {
        return this.keyVaultProperties;
    }

    public ElasticEncryption withKeyVaultProperties(ElasticKeyVaultProperties keyVaultProperties) {
        this.keyVaultProperties = keyVaultProperties;
        return this;
    }

    public ElasticEncryptionIdentity identity() {
        return this.identity;
    }

    public ElasticEncryption withIdentity(ElasticEncryptionIdentity identity) {
        this.identity = identity;
        return this;
    }

    public void validate() {
        if (this.keyVaultProperties() != null) {
            this.keyVaultProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keySource", this.keySource == null ? null : this.keySource.toString());
        jsonWriter.writeJsonField("keyVaultProperties", (JsonSerializable)this.keyVaultProperties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static ElasticEncryption fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticEncryption)jsonReader.readObject(reader -> {
            ElasticEncryption deserializedElasticEncryption = new ElasticEncryption();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keySource".equals(fieldName)) {
                    deserializedElasticEncryption.keySource = KeySource.fromString(reader.getString());
                    continue;
                }
                if ("keyVaultProperties".equals(fieldName)) {
                    deserializedElasticEncryption.keyVaultProperties = ElasticKeyVaultProperties.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedElasticEncryption.identity = ElasticEncryptionIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticEncryption;
        });
    }
}

