/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.ElasticEncryptionConfiguration;
import java.io.IOException;

public final class ElasticCapacityPoolUpdateProperties
implements JsonSerializable<ElasticCapacityPoolUpdateProperties> {
    private Long size;
    private ElasticEncryptionConfiguration encryption;
    private String activeDirectoryConfigResourceId;

    public Long size() {
        return this.size;
    }

    public ElasticCapacityPoolUpdateProperties withSize(Long size) {
        this.size = size;
        return this;
    }

    public ElasticEncryptionConfiguration encryption() {
        return this.encryption;
    }

    public ElasticCapacityPoolUpdateProperties withEncryption(ElasticEncryptionConfiguration encryption) {
        this.encryption = encryption;
        return this;
    }

    public String activeDirectoryConfigResourceId() {
        return this.activeDirectoryConfigResourceId;
    }

    public ElasticCapacityPoolUpdateProperties withActiveDirectoryConfigResourceId(String activeDirectoryConfigResourceId) {
        this.activeDirectoryConfigResourceId = activeDirectoryConfigResourceId;
        return this;
    }

    public void validate() {
        if (this.encryption() != null) {
            this.encryption().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("size", (Number)this.size);
        jsonWriter.writeJsonField("encryption", (JsonSerializable)this.encryption);
        jsonWriter.writeStringField("activeDirectoryConfigResourceId", this.activeDirectoryConfigResourceId);
        return jsonWriter.writeEndObject();
    }

    public static ElasticCapacityPoolUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticCapacityPoolUpdateProperties)jsonReader.readObject(reader -> {
            ElasticCapacityPoolUpdateProperties deserializedElasticCapacityPoolUpdateProperties = new ElasticCapacityPoolUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("size".equals(fieldName)) {
                    deserializedElasticCapacityPoolUpdateProperties.size = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedElasticCapacityPoolUpdateProperties.encryption = ElasticEncryptionConfiguration.fromJson(reader);
                    continue;
                }
                if ("activeDirectoryConfigResourceId".equals(fieldName)) {
                    deserializedElasticCapacityPoolUpdateProperties.activeDirectoryConfigResourceId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticCapacityPoolUpdateProperties;
        });
    }
}

