/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.ElasticEncryptionConfiguration;
import com.azure.resourcemanager.netapp.models.ElasticResourceAvailabilityStatus;
import com.azure.resourcemanager.netapp.models.ElasticServiceLevel;
import com.azure.resourcemanager.netapp.models.ProvisioningState;
import java.io.IOException;

public final class ElasticCapacityPoolProperties
implements JsonSerializable<ElasticCapacityPoolProperties> {
    private long size;
    private ElasticServiceLevel serviceLevel;
    private ProvisioningState provisioningState;
    private ElasticEncryptionConfiguration encryption;
    private Double totalThroughputMibps;
    private String subnetResourceId;
    private String currentZone;
    private ElasticResourceAvailabilityStatus availabilityStatus;
    private String activeDirectoryConfigResourceId;
    private static final ClientLogger LOGGER = new ClientLogger(ElasticCapacityPoolProperties.class);

    public long size() {
        return this.size;
    }

    public ElasticCapacityPoolProperties withSize(long size) {
        this.size = size;
        return this;
    }

    public ElasticServiceLevel serviceLevel() {
        return this.serviceLevel;
    }

    public ElasticCapacityPoolProperties withServiceLevel(ElasticServiceLevel serviceLevel) {
        this.serviceLevel = serviceLevel;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ElasticEncryptionConfiguration encryption() {
        return this.encryption;
    }

    public ElasticCapacityPoolProperties withEncryption(ElasticEncryptionConfiguration encryption) {
        this.encryption = encryption;
        return this;
    }

    public Double totalThroughputMibps() {
        return this.totalThroughputMibps;
    }

    public String subnetResourceId() {
        return this.subnetResourceId;
    }

    public ElasticCapacityPoolProperties withSubnetResourceId(String subnetResourceId) {
        this.subnetResourceId = subnetResourceId;
        return this;
    }

    public String currentZone() {
        return this.currentZone;
    }

    public ElasticResourceAvailabilityStatus availabilityStatus() {
        return this.availabilityStatus;
    }

    public String activeDirectoryConfigResourceId() {
        return this.activeDirectoryConfigResourceId;
    }

    public ElasticCapacityPoolProperties withActiveDirectoryConfigResourceId(String activeDirectoryConfigResourceId) {
        this.activeDirectoryConfigResourceId = activeDirectoryConfigResourceId;
        return this;
    }

    public void validate() {
        if (this.serviceLevel() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property serviceLevel in model ElasticCapacityPoolProperties"));
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.subnetResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subnetResourceId in model ElasticCapacityPoolProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("size", this.size);
        jsonWriter.writeStringField("serviceLevel", this.serviceLevel == null ? null : this.serviceLevel.toString());
        jsonWriter.writeStringField("subnetResourceId", this.subnetResourceId);
        jsonWriter.writeJsonField("encryption", (JsonSerializable)this.encryption);
        jsonWriter.writeStringField("activeDirectoryConfigResourceId", this.activeDirectoryConfigResourceId);
        return jsonWriter.writeEndObject();
    }

    public static ElasticCapacityPoolProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticCapacityPoolProperties)jsonReader.readObject(reader -> {
            ElasticCapacityPoolProperties deserializedElasticCapacityPoolProperties = new ElasticCapacityPoolProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("size".equals(fieldName)) {
                    deserializedElasticCapacityPoolProperties.size = reader.getLong();
                    continue;
                }
                if ("serviceLevel".equals(fieldName)) {
                    deserializedElasticCapacityPoolProperties.serviceLevel = ElasticServiceLevel.fromString(reader.getString());
                    continue;
                }
                if ("subnetResourceId".equals(fieldName)) {
                    deserializedElasticCapacityPoolProperties.subnetResourceId = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedElasticCapacityPoolProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedElasticCapacityPoolProperties.encryption = ElasticEncryptionConfiguration.fromJson(reader);
                    continue;
                }
                if ("totalThroughputMibps".equals(fieldName)) {
                    deserializedElasticCapacityPoolProperties.totalThroughputMibps = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("currentZone".equals(fieldName)) {
                    deserializedElasticCapacityPoolProperties.currentZone = reader.getString();
                    continue;
                }
                if ("availabilityStatus".equals(fieldName)) {
                    deserializedElasticCapacityPoolProperties.availabilityStatus = ElasticResourceAvailabilityStatus.fromString(reader.getString());
                    continue;
                }
                if ("activeDirectoryConfigResourceId".equals(fieldName)) {
                    deserializedElasticCapacityPoolProperties.activeDirectoryConfigResourceId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticCapacityPoolProperties;
        });
    }
}

