/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.ElasticBackupType;
import com.azure.resourcemanager.netapp.models.ProvisioningState;
import com.azure.resourcemanager.netapp.models.SnapshotUsage;
import com.azure.resourcemanager.netapp.models.VolumeSize;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ElasticBackupProperties
implements JsonSerializable<ElasticBackupProperties> {
    private OffsetDateTime creationDate;
    private OffsetDateTime snapshotCreationDate;
    private OffsetDateTime completionDate;
    private ProvisioningState provisioningState;
    private Long size;
    private String label;
    private ElasticBackupType backupType;
    private String failureReason;
    private String elasticVolumeResourceId;
    private SnapshotUsage snapshotUsage;
    private String elasticSnapshotResourceId;
    private String elasticBackupPolicyResourceId;
    private VolumeSize volumeSize;
    private static final ClientLogger LOGGER = new ClientLogger(ElasticBackupProperties.class);

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public OffsetDateTime snapshotCreationDate() {
        return this.snapshotCreationDate;
    }

    public OffsetDateTime completionDate() {
        return this.completionDate;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Long size() {
        return this.size;
    }

    public String label() {
        return this.label;
    }

    public ElasticBackupProperties withLabel(String label) {
        this.label = label;
        return this;
    }

    public ElasticBackupType backupType() {
        return this.backupType;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public String elasticVolumeResourceId() {
        return this.elasticVolumeResourceId;
    }

    public ElasticBackupProperties withElasticVolumeResourceId(String elasticVolumeResourceId) {
        this.elasticVolumeResourceId = elasticVolumeResourceId;
        return this;
    }

    public SnapshotUsage snapshotUsage() {
        return this.snapshotUsage;
    }

    public ElasticBackupProperties withSnapshotUsage(SnapshotUsage snapshotUsage) {
        this.snapshotUsage = snapshotUsage;
        return this;
    }

    public String elasticSnapshotResourceId() {
        return this.elasticSnapshotResourceId;
    }

    public ElasticBackupProperties withElasticSnapshotResourceId(String elasticSnapshotResourceId) {
        this.elasticSnapshotResourceId = elasticSnapshotResourceId;
        return this;
    }

    public String elasticBackupPolicyResourceId() {
        return this.elasticBackupPolicyResourceId;
    }

    public VolumeSize volumeSize() {
        return this.volumeSize;
    }

    public void validate() {
        if (this.elasticVolumeResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property elasticVolumeResourceId in model ElasticBackupProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("elasticVolumeResourceId", this.elasticVolumeResourceId);
        jsonWriter.writeStringField("label", this.label);
        jsonWriter.writeStringField("snapshotUsage", this.snapshotUsage == null ? null : this.snapshotUsage.toString());
        jsonWriter.writeStringField("elasticSnapshotResourceId", this.elasticSnapshotResourceId);
        return jsonWriter.writeEndObject();
    }

    public static ElasticBackupProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticBackupProperties)jsonReader.readObject(reader -> {
            ElasticBackupProperties deserializedElasticBackupProperties = new ElasticBackupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("elasticVolumeResourceId".equals(fieldName)) {
                    deserializedElasticBackupProperties.elasticVolumeResourceId = reader.getString();
                    continue;
                }
                if ("creationDate".equals(fieldName)) {
                    deserializedElasticBackupProperties.creationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("snapshotCreationDate".equals(fieldName)) {
                    deserializedElasticBackupProperties.snapshotCreationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("completionDate".equals(fieldName)) {
                    deserializedElasticBackupProperties.completionDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedElasticBackupProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("size".equals(fieldName)) {
                    deserializedElasticBackupProperties.size = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("label".equals(fieldName)) {
                    deserializedElasticBackupProperties.label = reader.getString();
                    continue;
                }
                if ("backupType".equals(fieldName)) {
                    deserializedElasticBackupProperties.backupType = ElasticBackupType.fromString(reader.getString());
                    continue;
                }
                if ("failureReason".equals(fieldName)) {
                    deserializedElasticBackupProperties.failureReason = reader.getString();
                    continue;
                }
                if ("snapshotUsage".equals(fieldName)) {
                    deserializedElasticBackupProperties.snapshotUsage = SnapshotUsage.fromString(reader.getString());
                    continue;
                }
                if ("elasticSnapshotResourceId".equals(fieldName)) {
                    deserializedElasticBackupProperties.elasticSnapshotResourceId = reader.getString();
                    continue;
                }
                if ("elasticBackupPolicyResourceId".equals(fieldName)) {
                    deserializedElasticBackupProperties.elasticBackupPolicyResourceId = reader.getString();
                    continue;
                }
                if ("volumeSize".equals(fieldName)) {
                    deserializedElasticBackupProperties.volumeSize = VolumeSize.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticBackupProperties;
        });
    }
}

