/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.ElasticBackupPolicyState;
import java.io.IOException;

public final class ElasticBackupPolicyUpdateProperties
implements JsonSerializable<ElasticBackupPolicyUpdateProperties> {
    private Integer dailyBackupsToKeep;
    private Integer weeklyBackupsToKeep;
    private Integer monthlyBackupsToKeep;
    private ElasticBackupPolicyState policyState;

    public Integer dailyBackupsToKeep() {
        return this.dailyBackupsToKeep;
    }

    public ElasticBackupPolicyUpdateProperties withDailyBackupsToKeep(Integer dailyBackupsToKeep) {
        this.dailyBackupsToKeep = dailyBackupsToKeep;
        return this;
    }

    public Integer weeklyBackupsToKeep() {
        return this.weeklyBackupsToKeep;
    }

    public ElasticBackupPolicyUpdateProperties withWeeklyBackupsToKeep(Integer weeklyBackupsToKeep) {
        this.weeklyBackupsToKeep = weeklyBackupsToKeep;
        return this;
    }

    public Integer monthlyBackupsToKeep() {
        return this.monthlyBackupsToKeep;
    }

    public ElasticBackupPolicyUpdateProperties withMonthlyBackupsToKeep(Integer monthlyBackupsToKeep) {
        this.monthlyBackupsToKeep = monthlyBackupsToKeep;
        return this;
    }

    public ElasticBackupPolicyState policyState() {
        return this.policyState;
    }

    public ElasticBackupPolicyUpdateProperties withPolicyState(ElasticBackupPolicyState policyState) {
        this.policyState = policyState;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("dailyBackupsToKeep", (Number)this.dailyBackupsToKeep);
        jsonWriter.writeNumberField("weeklyBackupsToKeep", (Number)this.weeklyBackupsToKeep);
        jsonWriter.writeNumberField("monthlyBackupsToKeep", (Number)this.monthlyBackupsToKeep);
        jsonWriter.writeStringField("policyState", this.policyState == null ? null : this.policyState.toString());
        return jsonWriter.writeEndObject();
    }

    public static ElasticBackupPolicyUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticBackupPolicyUpdateProperties)jsonReader.readObject(reader -> {
            ElasticBackupPolicyUpdateProperties deserializedElasticBackupPolicyUpdateProperties = new ElasticBackupPolicyUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dailyBackupsToKeep".equals(fieldName)) {
                    deserializedElasticBackupPolicyUpdateProperties.dailyBackupsToKeep = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("weeklyBackupsToKeep".equals(fieldName)) {
                    deserializedElasticBackupPolicyUpdateProperties.weeklyBackupsToKeep = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("monthlyBackupsToKeep".equals(fieldName)) {
                    deserializedElasticBackupPolicyUpdateProperties.monthlyBackupsToKeep = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("policyState".equals(fieldName)) {
                    deserializedElasticBackupPolicyUpdateProperties.policyState = ElasticBackupPolicyState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticBackupPolicyUpdateProperties;
        });
    }
}

