/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.ElasticBackupPolicyState;
import com.azure.resourcemanager.netapp.models.ProvisioningState;
import java.io.IOException;

public final class ElasticBackupPolicyProperties
implements JsonSerializable<ElasticBackupPolicyProperties> {
    private ProvisioningState provisioningState;
    private Integer dailyBackupsToKeep;
    private Integer weeklyBackupsToKeep;
    private Integer monthlyBackupsToKeep;
    private Integer assignedVolumesCount;
    private ElasticBackupPolicyState policyState;

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Integer dailyBackupsToKeep() {
        return this.dailyBackupsToKeep;
    }

    public ElasticBackupPolicyProperties withDailyBackupsToKeep(Integer dailyBackupsToKeep) {
        this.dailyBackupsToKeep = dailyBackupsToKeep;
        return this;
    }

    public Integer weeklyBackupsToKeep() {
        return this.weeklyBackupsToKeep;
    }

    public ElasticBackupPolicyProperties withWeeklyBackupsToKeep(Integer weeklyBackupsToKeep) {
        this.weeklyBackupsToKeep = weeklyBackupsToKeep;
        return this;
    }

    public Integer monthlyBackupsToKeep() {
        return this.monthlyBackupsToKeep;
    }

    public ElasticBackupPolicyProperties withMonthlyBackupsToKeep(Integer monthlyBackupsToKeep) {
        this.monthlyBackupsToKeep = monthlyBackupsToKeep;
        return this;
    }

    public Integer assignedVolumesCount() {
        return this.assignedVolumesCount;
    }

    public ElasticBackupPolicyState policyState() {
        return this.policyState;
    }

    public ElasticBackupPolicyProperties withPolicyState(ElasticBackupPolicyState policyState) {
        this.policyState = policyState;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("dailyBackupsToKeep", (Number)this.dailyBackupsToKeep);
        jsonWriter.writeNumberField("weeklyBackupsToKeep", (Number)this.weeklyBackupsToKeep);
        jsonWriter.writeNumberField("monthlyBackupsToKeep", (Number)this.monthlyBackupsToKeep);
        jsonWriter.writeStringField("policyState", this.policyState == null ? null : this.policyState.toString());
        return jsonWriter.writeEndObject();
    }

    public static ElasticBackupPolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticBackupPolicyProperties)jsonReader.readObject(reader -> {
            ElasticBackupPolicyProperties deserializedElasticBackupPolicyProperties = new ElasticBackupPolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedElasticBackupPolicyProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("dailyBackupsToKeep".equals(fieldName)) {
                    deserializedElasticBackupPolicyProperties.dailyBackupsToKeep = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("weeklyBackupsToKeep".equals(fieldName)) {
                    deserializedElasticBackupPolicyProperties.weeklyBackupsToKeep = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("monthlyBackupsToKeep".equals(fieldName)) {
                    deserializedElasticBackupPolicyProperties.monthlyBackupsToKeep = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("assignedVolumesCount".equals(fieldName)) {
                    deserializedElasticBackupPolicyProperties.assignedVolumesCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("policyState".equals(fieldName)) {
                    deserializedElasticBackupPolicyProperties.policyState = ElasticBackupPolicyState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticBackupPolicyProperties;
        });
    }
}

