/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.ElasticAccountUpdateProperties;
import com.azure.resourcemanager.netapp.models.ManagedServiceIdentity;
import java.io.IOException;
import java.util.Map;

public final class ElasticAccountUpdate
implements JsonSerializable<ElasticAccountUpdate> {
    private ManagedServiceIdentity identity;
    private Map<String, String> tags;
    private ElasticAccountUpdateProperties properties;

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public ElasticAccountUpdate withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ElasticAccountUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public ElasticAccountUpdateProperties properties() {
        return this.properties;
    }

    public ElasticAccountUpdate withProperties(ElasticAccountUpdateProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static ElasticAccountUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticAccountUpdate)jsonReader.readObject(reader -> {
            ElasticAccountUpdate deserializedElasticAccountUpdate = new ElasticAccountUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("identity".equals(fieldName)) {
                    deserializedElasticAccountUpdate.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedElasticAccountUpdate.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedElasticAccountUpdate.properties = ElasticAccountUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticAccountUpdate;
        });
    }
}

