/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.ElasticEncryption;
import com.azure.resourcemanager.netapp.models.ProvisioningState;
import java.io.IOException;

public final class ElasticAccountProperties
implements JsonSerializable<ElasticAccountProperties> {
    private ProvisioningState provisioningState;
    private ElasticEncryption encryption;

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public ElasticEncryption encryption() {
        return this.encryption;
    }

    public ElasticAccountProperties withEncryption(ElasticEncryption encryption) {
        this.encryption = encryption;
        return this;
    }

    public void validate() {
        if (this.encryption() != null) {
            this.encryption().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("encryption", (JsonSerializable)this.encryption);
        return jsonWriter.writeEndObject();
    }

    public static ElasticAccountProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticAccountProperties)jsonReader.readObject(reader -> {
            ElasticAccountProperties deserializedElasticAccountProperties = new ElasticAccountProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedElasticAccountProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedElasticAccountProperties.encryption = ElasticEncryption.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticAccountProperties;
        });
    }
}

