/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.CachePropertiesExportPolicy;
import com.azure.resourcemanager.netapp.models.CifsChangeNotifyState;
import com.azure.resourcemanager.netapp.models.EnableWriteBackState;
import com.azure.resourcemanager.netapp.models.ProtocolTypes;
import com.azure.resourcemanager.netapp.models.SmbSettings;
import java.io.IOException;
import java.util.List;

public final class CacheUpdateProperties
implements JsonSerializable<CacheUpdateProperties> {
    private Long size;
    private CachePropertiesExportPolicy exportPolicy;
    private List<ProtocolTypes> protocolTypes;
    private SmbSettings smbSettings;
    private Float throughputMibps;
    private String keyVaultPrivateEndpointResourceId;
    private CifsChangeNotifyState cifsChangeNotifications;
    private EnableWriteBackState writeBack;

    public Long size() {
        return this.size;
    }

    public CacheUpdateProperties withSize(Long size) {
        this.size = size;
        return this;
    }

    public CachePropertiesExportPolicy exportPolicy() {
        return this.exportPolicy;
    }

    public CacheUpdateProperties withExportPolicy(CachePropertiesExportPolicy exportPolicy) {
        this.exportPolicy = exportPolicy;
        return this;
    }

    public List<ProtocolTypes> protocolTypes() {
        return this.protocolTypes;
    }

    public CacheUpdateProperties withProtocolTypes(List<ProtocolTypes> protocolTypes) {
        this.protocolTypes = protocolTypes;
        return this;
    }

    public SmbSettings smbSettings() {
        return this.smbSettings;
    }

    public CacheUpdateProperties withSmbSettings(SmbSettings smbSettings) {
        this.smbSettings = smbSettings;
        return this;
    }

    public Float throughputMibps() {
        return this.throughputMibps;
    }

    public CacheUpdateProperties withThroughputMibps(Float throughputMibps) {
        this.throughputMibps = throughputMibps;
        return this;
    }

    public String keyVaultPrivateEndpointResourceId() {
        return this.keyVaultPrivateEndpointResourceId;
    }

    public CacheUpdateProperties withKeyVaultPrivateEndpointResourceId(String keyVaultPrivateEndpointResourceId) {
        this.keyVaultPrivateEndpointResourceId = keyVaultPrivateEndpointResourceId;
        return this;
    }

    public CifsChangeNotifyState cifsChangeNotifications() {
        return this.cifsChangeNotifications;
    }

    public CacheUpdateProperties withCifsChangeNotifications(CifsChangeNotifyState cifsChangeNotifications) {
        this.cifsChangeNotifications = cifsChangeNotifications;
        return this;
    }

    public EnableWriteBackState writeBack() {
        return this.writeBack;
    }

    public CacheUpdateProperties withWriteBack(EnableWriteBackState writeBack) {
        this.writeBack = writeBack;
        return this;
    }

    public void validate() {
        if (this.exportPolicy() != null) {
            this.exportPolicy().validate();
        }
        if (this.smbSettings() != null) {
            this.smbSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("size", (Number)this.size);
        jsonWriter.writeJsonField("exportPolicy", (JsonSerializable)this.exportPolicy);
        jsonWriter.writeArrayField("protocolTypes", this.protocolTypes, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeJsonField("smbSettings", (JsonSerializable)this.smbSettings);
        jsonWriter.writeNumberField("throughputMibps", (Number)this.throughputMibps);
        jsonWriter.writeStringField("keyVaultPrivateEndpointResourceId", this.keyVaultPrivateEndpointResourceId);
        jsonWriter.writeStringField("cifsChangeNotifications", this.cifsChangeNotifications == null ? null : this.cifsChangeNotifications.toString());
        jsonWriter.writeStringField("writeBack", this.writeBack == null ? null : this.writeBack.toString());
        return jsonWriter.writeEndObject();
    }

    public static CacheUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CacheUpdateProperties)jsonReader.readObject(reader -> {
            CacheUpdateProperties deserializedCacheUpdateProperties = new CacheUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("size".equals(fieldName)) {
                    deserializedCacheUpdateProperties.size = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("exportPolicy".equals(fieldName)) {
                    deserializedCacheUpdateProperties.exportPolicy = CachePropertiesExportPolicy.fromJson(reader);
                    continue;
                }
                if ("protocolTypes".equals(fieldName)) {
                    List protocolTypes;
                    deserializedCacheUpdateProperties.protocolTypes = protocolTypes = reader.readArray(reader1 -> ProtocolTypes.fromString(reader1.getString()));
                    continue;
                }
                if ("smbSettings".equals(fieldName)) {
                    deserializedCacheUpdateProperties.smbSettings = SmbSettings.fromJson(reader);
                    continue;
                }
                if ("throughputMibps".equals(fieldName)) {
                    deserializedCacheUpdateProperties.throughputMibps = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("keyVaultPrivateEndpointResourceId".equals(fieldName)) {
                    deserializedCacheUpdateProperties.keyVaultPrivateEndpointResourceId = reader.getString();
                    continue;
                }
                if ("cifsChangeNotifications".equals(fieldName)) {
                    deserializedCacheUpdateProperties.cifsChangeNotifications = CifsChangeNotifyState.fromString(reader.getString());
                    continue;
                }
                if ("writeBack".equals(fieldName)) {
                    deserializedCacheUpdateProperties.writeBack = EnableWriteBackState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCacheUpdateProperties;
        });
    }
}

