/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.CacheLifeCycleState;
import com.azure.resourcemanager.netapp.models.CacheMountTargetProperties;
import com.azure.resourcemanager.netapp.models.CachePropertiesExportPolicy;
import com.azure.resourcemanager.netapp.models.CacheProvisioningState;
import com.azure.resourcemanager.netapp.models.CifsChangeNotifyState;
import com.azure.resourcemanager.netapp.models.EnableWriteBackState;
import com.azure.resourcemanager.netapp.models.EncryptionKeySource;
import com.azure.resourcemanager.netapp.models.EncryptionState;
import com.azure.resourcemanager.netapp.models.GlobalFileLockingState;
import com.azure.resourcemanager.netapp.models.KerberosState;
import com.azure.resourcemanager.netapp.models.LdapServerType;
import com.azure.resourcemanager.netapp.models.LdapState;
import com.azure.resourcemanager.netapp.models.OriginClusterInformation;
import com.azure.resourcemanager.netapp.models.ProtocolTypes;
import com.azure.resourcemanager.netapp.models.SmbSettings;
import com.azure.resourcemanager.netapp.models.VolumeLanguage;
import java.io.IOException;
import java.util.List;

public final class CacheProperties
implements JsonSerializable<CacheProperties> {
    private String filepath;
    private long size;
    private CachePropertiesExportPolicy exportPolicy;
    private List<ProtocolTypes> protocolTypes;
    private CacheProvisioningState provisioningState;
    private CacheLifeCycleState cacheState;
    private String cacheSubnetResourceId;
    private String peeringSubnetResourceId;
    private List<CacheMountTargetProperties> mountTargets;
    private KerberosState kerberos;
    private SmbSettings smbSettings;
    private Float throughputMibps;
    private Float actualThroughputMibps;
    private EncryptionKeySource encryptionKeySource;
    private String keyVaultPrivateEndpointResourceId;
    private Long maximumNumberOfFiles;
    private EncryptionState encryption;
    private VolumeLanguage language;
    private LdapState ldap;
    private LdapServerType ldapServerType;
    private OriginClusterInformation originClusterInformation;
    private CifsChangeNotifyState cifsChangeNotifications;
    private GlobalFileLockingState globalFileLocking;
    private EnableWriteBackState writeBack;
    private static final ClientLogger LOGGER = new ClientLogger(CacheProperties.class);

    public String filepath() {
        return this.filepath;
    }

    public CacheProperties withFilepath(String filepath) {
        this.filepath = filepath;
        return this;
    }

    public long size() {
        return this.size;
    }

    public CacheProperties withSize(long size) {
        this.size = size;
        return this;
    }

    public CachePropertiesExportPolicy exportPolicy() {
        return this.exportPolicy;
    }

    public CacheProperties withExportPolicy(CachePropertiesExportPolicy exportPolicy) {
        this.exportPolicy = exportPolicy;
        return this;
    }

    public List<ProtocolTypes> protocolTypes() {
        return this.protocolTypes;
    }

    public CacheProperties withProtocolTypes(List<ProtocolTypes> protocolTypes) {
        this.protocolTypes = protocolTypes;
        return this;
    }

    public CacheProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public CacheLifeCycleState cacheState() {
        return this.cacheState;
    }

    public String cacheSubnetResourceId() {
        return this.cacheSubnetResourceId;
    }

    public CacheProperties withCacheSubnetResourceId(String cacheSubnetResourceId) {
        this.cacheSubnetResourceId = cacheSubnetResourceId;
        return this;
    }

    public String peeringSubnetResourceId() {
        return this.peeringSubnetResourceId;
    }

    public CacheProperties withPeeringSubnetResourceId(String peeringSubnetResourceId) {
        this.peeringSubnetResourceId = peeringSubnetResourceId;
        return this;
    }

    public List<CacheMountTargetProperties> mountTargets() {
        return this.mountTargets;
    }

    public KerberosState kerberos() {
        return this.kerberos;
    }

    public CacheProperties withKerberos(KerberosState kerberos) {
        this.kerberos = kerberos;
        return this;
    }

    public SmbSettings smbSettings() {
        return this.smbSettings;
    }

    public CacheProperties withSmbSettings(SmbSettings smbSettings) {
        this.smbSettings = smbSettings;
        return this;
    }

    public Float throughputMibps() {
        return this.throughputMibps;
    }

    public CacheProperties withThroughputMibps(Float throughputMibps) {
        this.throughputMibps = throughputMibps;
        return this;
    }

    public Float actualThroughputMibps() {
        return this.actualThroughputMibps;
    }

    public EncryptionKeySource encryptionKeySource() {
        return this.encryptionKeySource;
    }

    public CacheProperties withEncryptionKeySource(EncryptionKeySource encryptionKeySource) {
        this.encryptionKeySource = encryptionKeySource;
        return this;
    }

    public String keyVaultPrivateEndpointResourceId() {
        return this.keyVaultPrivateEndpointResourceId;
    }

    public CacheProperties withKeyVaultPrivateEndpointResourceId(String keyVaultPrivateEndpointResourceId) {
        this.keyVaultPrivateEndpointResourceId = keyVaultPrivateEndpointResourceId;
        return this;
    }

    public Long maximumNumberOfFiles() {
        return this.maximumNumberOfFiles;
    }

    public EncryptionState encryption() {
        return this.encryption;
    }

    public VolumeLanguage language() {
        return this.language;
    }

    public LdapState ldap() {
        return this.ldap;
    }

    public CacheProperties withLdap(LdapState ldap) {
        this.ldap = ldap;
        return this;
    }

    public LdapServerType ldapServerType() {
        return this.ldapServerType;
    }

    public CacheProperties withLdapServerType(LdapServerType ldapServerType) {
        this.ldapServerType = ldapServerType;
        return this;
    }

    public OriginClusterInformation originClusterInformation() {
        return this.originClusterInformation;
    }

    public CacheProperties withOriginClusterInformation(OriginClusterInformation originClusterInformation) {
        this.originClusterInformation = originClusterInformation;
        return this;
    }

    public CifsChangeNotifyState cifsChangeNotifications() {
        return this.cifsChangeNotifications;
    }

    public CacheProperties withCifsChangeNotifications(CifsChangeNotifyState cifsChangeNotifications) {
        this.cifsChangeNotifications = cifsChangeNotifications;
        return this;
    }

    public GlobalFileLockingState globalFileLocking() {
        return this.globalFileLocking;
    }

    public CacheProperties withGlobalFileLocking(GlobalFileLockingState globalFileLocking) {
        this.globalFileLocking = globalFileLocking;
        return this;
    }

    public EnableWriteBackState writeBack() {
        return this.writeBack;
    }

    public CacheProperties withWriteBack(EnableWriteBackState writeBack) {
        this.writeBack = writeBack;
        return this;
    }

    public void validate() {
        if (this.filepath() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property filepath in model CacheProperties"));
        }
        if (this.exportPolicy() != null) {
            this.exportPolicy().validate();
        }
        if (this.cacheSubnetResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property cacheSubnetResourceId in model CacheProperties"));
        }
        if (this.peeringSubnetResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property peeringSubnetResourceId in model CacheProperties"));
        }
        if (this.mountTargets() != null) {
            this.mountTargets().forEach(e -> e.validate());
        }
        if (this.smbSettings() != null) {
            this.smbSettings().validate();
        }
        if (this.encryptionKeySource() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property encryptionKeySource in model CacheProperties"));
        }
        if (this.originClusterInformation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property originClusterInformation in model CacheProperties"));
        }
        this.originClusterInformation().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("filepath", this.filepath);
        jsonWriter.writeLongField("size", this.size);
        jsonWriter.writeStringField("cacheSubnetResourceId", this.cacheSubnetResourceId);
        jsonWriter.writeStringField("peeringSubnetResourceId", this.peeringSubnetResourceId);
        jsonWriter.writeStringField("encryptionKeySource", this.encryptionKeySource == null ? null : this.encryptionKeySource.toString());
        jsonWriter.writeJsonField("originClusterInformation", (JsonSerializable)this.originClusterInformation);
        jsonWriter.writeJsonField("exportPolicy", (JsonSerializable)this.exportPolicy);
        jsonWriter.writeArrayField("protocolTypes", this.protocolTypes, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("kerberos", this.kerberos == null ? null : this.kerberos.toString());
        jsonWriter.writeJsonField("smbSettings", (JsonSerializable)this.smbSettings);
        jsonWriter.writeNumberField("throughputMibps", (Number)this.throughputMibps);
        jsonWriter.writeStringField("keyVaultPrivateEndpointResourceId", this.keyVaultPrivateEndpointResourceId);
        jsonWriter.writeStringField("ldap", this.ldap == null ? null : this.ldap.toString());
        jsonWriter.writeStringField("ldapServerType", this.ldapServerType == null ? null : this.ldapServerType.toString());
        jsonWriter.writeStringField("cifsChangeNotifications", this.cifsChangeNotifications == null ? null : this.cifsChangeNotifications.toString());
        jsonWriter.writeStringField("globalFileLocking", this.globalFileLocking == null ? null : this.globalFileLocking.toString());
        jsonWriter.writeStringField("writeBack", this.writeBack == null ? null : this.writeBack.toString());
        return jsonWriter.writeEndObject();
    }

    public static CacheProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CacheProperties)jsonReader.readObject(reader -> {
            CacheProperties deserializedCacheProperties = new CacheProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("filepath".equals(fieldName)) {
                    deserializedCacheProperties.filepath = reader.getString();
                    continue;
                }
                if ("size".equals(fieldName)) {
                    deserializedCacheProperties.size = reader.getLong();
                    continue;
                }
                if ("cacheSubnetResourceId".equals(fieldName)) {
                    deserializedCacheProperties.cacheSubnetResourceId = reader.getString();
                    continue;
                }
                if ("peeringSubnetResourceId".equals(fieldName)) {
                    deserializedCacheProperties.peeringSubnetResourceId = reader.getString();
                    continue;
                }
                if ("encryptionKeySource".equals(fieldName)) {
                    deserializedCacheProperties.encryptionKeySource = EncryptionKeySource.fromString(reader.getString());
                    continue;
                }
                if ("originClusterInformation".equals(fieldName)) {
                    deserializedCacheProperties.originClusterInformation = OriginClusterInformation.fromJson(reader);
                    continue;
                }
                if ("exportPolicy".equals(fieldName)) {
                    deserializedCacheProperties.exportPolicy = CachePropertiesExportPolicy.fromJson(reader);
                    continue;
                }
                if ("protocolTypes".equals(fieldName)) {
                    List protocolTypes;
                    deserializedCacheProperties.protocolTypes = protocolTypes = reader.readArray(reader1 -> ProtocolTypes.fromString(reader1.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedCacheProperties.provisioningState = CacheProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("cacheState".equals(fieldName)) {
                    deserializedCacheProperties.cacheState = CacheLifeCycleState.fromString(reader.getString());
                    continue;
                }
                if ("mountTargets".equals(fieldName)) {
                    List mountTargets;
                    deserializedCacheProperties.mountTargets = mountTargets = reader.readArray(reader1 -> CacheMountTargetProperties.fromJson(reader1));
                    continue;
                }
                if ("kerberos".equals(fieldName)) {
                    deserializedCacheProperties.kerberos = KerberosState.fromString(reader.getString());
                    continue;
                }
                if ("smbSettings".equals(fieldName)) {
                    deserializedCacheProperties.smbSettings = SmbSettings.fromJson(reader);
                    continue;
                }
                if ("throughputMibps".equals(fieldName)) {
                    deserializedCacheProperties.throughputMibps = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("actualThroughputMibps".equals(fieldName)) {
                    deserializedCacheProperties.actualThroughputMibps = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("keyVaultPrivateEndpointResourceId".equals(fieldName)) {
                    deserializedCacheProperties.keyVaultPrivateEndpointResourceId = reader.getString();
                    continue;
                }
                if ("maximumNumberOfFiles".equals(fieldName)) {
                    deserializedCacheProperties.maximumNumberOfFiles = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedCacheProperties.encryption = EncryptionState.fromString(reader.getString());
                    continue;
                }
                if ("language".equals(fieldName)) {
                    deserializedCacheProperties.language = VolumeLanguage.fromString(reader.getString());
                    continue;
                }
                if ("ldap".equals(fieldName)) {
                    deserializedCacheProperties.ldap = LdapState.fromString(reader.getString());
                    continue;
                }
                if ("ldapServerType".equals(fieldName)) {
                    deserializedCacheProperties.ldapServerType = LdapServerType.fromString(reader.getString());
                    continue;
                }
                if ("cifsChangeNotifications".equals(fieldName)) {
                    deserializedCacheProperties.cifsChangeNotifications = CifsChangeNotifyState.fromString(reader.getString());
                    continue;
                }
                if ("globalFileLocking".equals(fieldName)) {
                    deserializedCacheProperties.globalFileLocking = GlobalFileLockingState.fromString(reader.getString());
                    continue;
                }
                if ("writeBack".equals(fieldName)) {
                    deserializedCacheProperties.writeBack = EnableWriteBackState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCacheProperties;
        });
    }
}

