/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.fluent.models.CacheInner;
import com.azure.resourcemanager.netapp.models.CacheProperties;
import com.azure.resourcemanager.netapp.models.CacheUpdateProperties;
import com.azure.resourcemanager.netapp.models.PeeringPassphrases;
import com.azure.resourcemanager.netapp.models.PoolChangeRequest;
import java.util.List;
import java.util.Map;

public interface Cache {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public CacheProperties properties();

    public String etag();

    public List<String> zones();

    public SystemData systemData();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public CacheInner innerModel();

    public Update update();

    public Cache refresh();

    public Cache refresh(Context var1);

    public Response<PeeringPassphrases> listPeeringPassphrasesWithResponse(Context var1);

    public PeeringPassphrases listPeeringPassphrases();

    public void poolChange(PoolChangeRequest var1);

    public void poolChange(PoolChangeRequest var1, Context var2);

    public static interface UpdateStages {

        public static interface WithProperties {
            public Update withProperties(CacheUpdateProperties var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithProperties {
        public Cache apply();

        public Cache apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithZones {
            public WithCreate withZones(List<String> var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithZones {
            public Cache create();

            public Cache create(Context var1);
        }

        public static interface WithProperties {
            public WithCreate withProperties(CacheProperties var1);
        }

        public static interface WithParentResource {
            public WithProperties withExistingCapacityPool(String var1, String var2, String var3);
        }

        public static interface WithLocation {
            public WithParentResource withRegion(Region var1);

            public WithParentResource withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithProperties,
    DefinitionStages.WithCreate {
    }
}

