/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class BucketServerProperties
implements JsonSerializable<BucketServerProperties> {
    private String fqdn;
    private String certificateCommonName;
    private OffsetDateTime certificateExpiryDate;
    private String ipAddress;
    private String certificateObject;

    public String fqdn() {
        return this.fqdn;
    }

    public BucketServerProperties withFqdn(String fqdn) {
        this.fqdn = fqdn;
        return this;
    }

    public String certificateCommonName() {
        return this.certificateCommonName;
    }

    public OffsetDateTime certificateExpiryDate() {
        return this.certificateExpiryDate;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public String certificateObject() {
        return this.certificateObject;
    }

    public BucketServerProperties withCertificateObject(String certificateObject) {
        this.certificateObject = certificateObject;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("fqdn", this.fqdn);
        jsonWriter.writeStringField("certificateObject", this.certificateObject);
        return jsonWriter.writeEndObject();
    }

    public static BucketServerProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BucketServerProperties)jsonReader.readObject(reader -> {
            BucketServerProperties deserializedBucketServerProperties = new BucketServerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("fqdn".equals(fieldName)) {
                    deserializedBucketServerProperties.fqdn = reader.getString();
                    continue;
                }
                if ("certificateCommonName".equals(fieldName)) {
                    deserializedBucketServerProperties.certificateCommonName = reader.getString();
                    continue;
                }
                if ("certificateExpiryDate".equals(fieldName)) {
                    deserializedBucketServerProperties.certificateExpiryDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("ipAddress".equals(fieldName)) {
                    deserializedBucketServerProperties.ipAddress = reader.getString();
                    continue;
                }
                if ("certificateObject".equals(fieldName)) {
                    deserializedBucketServerProperties.certificateObject = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBucketServerProperties;
        });
    }
}

