/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.fluent.models.BucketPatchProperties;
import com.azure.resourcemanager.netapp.models.BucketPatchPermissions;
import com.azure.resourcemanager.netapp.models.BucketServerPatchProperties;
import com.azure.resourcemanager.netapp.models.FileSystemUser;
import com.azure.resourcemanager.netapp.models.ProvisioningState;
import java.io.IOException;

public final class BucketPatch
extends ProxyResource {
    private BucketPatchProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private BucketPatchProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String path() {
        return this.innerProperties() == null ? null : this.innerProperties().path();
    }

    public BucketPatch withPath(String path) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BucketPatchProperties();
        }
        this.innerProperties().withPath(path);
        return this;
    }

    public FileSystemUser fileSystemUser() {
        return this.innerProperties() == null ? null : this.innerProperties().fileSystemUser();
    }

    public BucketPatch withFileSystemUser(FileSystemUser fileSystemUser) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BucketPatchProperties();
        }
        this.innerProperties().withFileSystemUser(fileSystemUser);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public BucketServerPatchProperties server() {
        return this.innerProperties() == null ? null : this.innerProperties().server();
    }

    public BucketPatch withServer(BucketServerPatchProperties server) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BucketPatchProperties();
        }
        this.innerProperties().withServer(server);
        return this;
    }

    public BucketPatchPermissions permissions() {
        return this.innerProperties() == null ? null : this.innerProperties().permissions();
    }

    public BucketPatch withPermissions(BucketPatchPermissions permissions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BucketPatchProperties();
        }
        this.innerProperties().withPermissions(permissions);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static BucketPatch fromJson(JsonReader jsonReader) throws IOException {
        return (BucketPatch)((Object)jsonReader.readObject(reader -> {
            BucketPatch deserializedBucketPatch = new BucketPatch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedBucketPatch.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedBucketPatch.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBucketPatch.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedBucketPatch.innerProperties = BucketPatchProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedBucketPatch.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBucketPatch;
        }));
    }
}

