/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.fluent.models.BucketInner;
import com.azure.resourcemanager.netapp.models.BucketCredentialsExpiry;
import com.azure.resourcemanager.netapp.models.BucketGenerateCredentials;
import com.azure.resourcemanager.netapp.models.BucketPatchPermissions;
import com.azure.resourcemanager.netapp.models.BucketPermissions;
import com.azure.resourcemanager.netapp.models.BucketServerPatchProperties;
import com.azure.resourcemanager.netapp.models.BucketServerProperties;
import com.azure.resourcemanager.netapp.models.CredentialsStatus;
import com.azure.resourcemanager.netapp.models.FileSystemUser;
import com.azure.resourcemanager.netapp.models.ProvisioningState;

public interface Bucket {
    public String id();

    public String name();

    public String type();

    public SystemData systemData();

    public String path();

    public FileSystemUser fileSystemUser();

    public ProvisioningState provisioningState();

    public CredentialsStatus status();

    public BucketServerProperties server();

    public BucketPermissions permissions();

    public String resourceGroupName();

    public BucketInner innerModel();

    public Update update();

    public Bucket refresh();

    public Bucket refresh(Context var1);

    public Response<BucketGenerateCredentials> generateCredentialsWithResponse(BucketCredentialsExpiry var1, Context var2);

    public BucketGenerateCredentials generateCredentials(BucketCredentialsExpiry var1);

    public static interface UpdateStages {

        public static interface WithPermissions {
            public Update withPermissions(BucketPatchPermissions var1);
        }

        public static interface WithServer {
            public Update withServer(BucketServerPatchProperties var1);
        }

        public static interface WithFileSystemUser {
            public Update withFileSystemUser(FileSystemUser var1);
        }

        public static interface WithPath {
            public Update withPath(String var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithPath,
    UpdateStages.WithFileSystemUser,
    UpdateStages.WithServer,
    UpdateStages.WithPermissions {
        public Bucket apply();

        public Bucket apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithPermissions {
            public WithCreate withPermissions(BucketPermissions var1);
        }

        public static interface WithServer {
            public WithCreate withServer(BucketServerProperties var1);
        }

        public static interface WithFileSystemUser {
            public WithCreate withFileSystemUser(FileSystemUser var1);
        }

        public static interface WithPath {
            public WithCreate withPath(String var1);
        }

        public static interface WithCreate
        extends WithPath,
        WithFileSystemUser,
        WithServer,
        WithPermissions {
            public Bucket create();

            public Bucket create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingVolume(String var1, String var2, String var3, String var4);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

