/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.SecretPassword;
import java.io.IOException;
import java.util.List;

public final class ActiveDirectoryConfigUpdateProperties
implements JsonSerializable<ActiveDirectoryConfigUpdateProperties> {
    private String userName;
    private List<String> dns;
    private String smbServerName;
    private String organizationalUnit;
    private String site;
    private List<String> backupOperators;
    private List<String> administrators;
    private List<String> securityOperators;
    private String domain;
    private SecretPassword secretPassword;

    public String userName() {
        return this.userName;
    }

    public ActiveDirectoryConfigUpdateProperties withUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public List<String> dns() {
        return this.dns;
    }

    public ActiveDirectoryConfigUpdateProperties withDns(List<String> dns) {
        this.dns = dns;
        return this;
    }

    public String smbServerName() {
        return this.smbServerName;
    }

    public ActiveDirectoryConfigUpdateProperties withSmbServerName(String smbServerName) {
        this.smbServerName = smbServerName;
        return this;
    }

    public String organizationalUnit() {
        return this.organizationalUnit;
    }

    public ActiveDirectoryConfigUpdateProperties withOrganizationalUnit(String organizationalUnit) {
        this.organizationalUnit = organizationalUnit;
        return this;
    }

    public String site() {
        return this.site;
    }

    public ActiveDirectoryConfigUpdateProperties withSite(String site) {
        this.site = site;
        return this;
    }

    public List<String> backupOperators() {
        return this.backupOperators;
    }

    public ActiveDirectoryConfigUpdateProperties withBackupOperators(List<String> backupOperators) {
        this.backupOperators = backupOperators;
        return this;
    }

    public List<String> administrators() {
        return this.administrators;
    }

    public ActiveDirectoryConfigUpdateProperties withAdministrators(List<String> administrators) {
        this.administrators = administrators;
        return this;
    }

    public List<String> securityOperators() {
        return this.securityOperators;
    }

    public ActiveDirectoryConfigUpdateProperties withSecurityOperators(List<String> securityOperators) {
        this.securityOperators = securityOperators;
        return this;
    }

    public String domain() {
        return this.domain;
    }

    public ActiveDirectoryConfigUpdateProperties withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public SecretPassword secretPassword() {
        return this.secretPassword;
    }

    public ActiveDirectoryConfigUpdateProperties withSecretPassword(SecretPassword secretPassword) {
        this.secretPassword = secretPassword;
        return this;
    }

    public void validate() {
        if (this.secretPassword() != null) {
            this.secretPassword().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("userName", this.userName);
        jsonWriter.writeArrayField("dns", this.dns, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("smbServerName", this.smbServerName);
        jsonWriter.writeStringField("organizationalUnit", this.organizationalUnit);
        jsonWriter.writeStringField("site", this.site);
        jsonWriter.writeArrayField("backupOperators", this.backupOperators, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("administrators", this.administrators, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("securityOperators", this.securityOperators, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("domain", this.domain);
        jsonWriter.writeJsonField("secretPassword", (JsonSerializable)this.secretPassword);
        return jsonWriter.writeEndObject();
    }

    public static ActiveDirectoryConfigUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ActiveDirectoryConfigUpdateProperties)jsonReader.readObject(reader -> {
            ActiveDirectoryConfigUpdateProperties deserializedActiveDirectoryConfigUpdateProperties = new ActiveDirectoryConfigUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("userName".equals(fieldName)) {
                    deserializedActiveDirectoryConfigUpdateProperties.userName = reader.getString();
                    continue;
                }
                if ("dns".equals(fieldName)) {
                    List dns;
                    deserializedActiveDirectoryConfigUpdateProperties.dns = dns = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("smbServerName".equals(fieldName)) {
                    deserializedActiveDirectoryConfigUpdateProperties.smbServerName = reader.getString();
                    continue;
                }
                if ("organizationalUnit".equals(fieldName)) {
                    deserializedActiveDirectoryConfigUpdateProperties.organizationalUnit = reader.getString();
                    continue;
                }
                if ("site".equals(fieldName)) {
                    deserializedActiveDirectoryConfigUpdateProperties.site = reader.getString();
                    continue;
                }
                if ("backupOperators".equals(fieldName)) {
                    List backupOperators;
                    deserializedActiveDirectoryConfigUpdateProperties.backupOperators = backupOperators = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("administrators".equals(fieldName)) {
                    List administrators;
                    deserializedActiveDirectoryConfigUpdateProperties.administrators = administrators = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("securityOperators".equals(fieldName)) {
                    List securityOperators;
                    deserializedActiveDirectoryConfigUpdateProperties.securityOperators = securityOperators = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("domain".equals(fieldName)) {
                    deserializedActiveDirectoryConfigUpdateProperties.domain = reader.getString();
                    continue;
                }
                if ("secretPassword".equals(fieldName)) {
                    deserializedActiveDirectoryConfigUpdateProperties.secretPassword = SecretPassword.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedActiveDirectoryConfigUpdateProperties;
        });
    }
}

