/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.models.ActiveDirectoryStatus;
import com.azure.resourcemanager.netapp.models.ProvisioningState;
import com.azure.resourcemanager.netapp.models.SecretPassword;
import java.io.IOException;
import java.util.List;

public final class ActiveDirectoryConfigProperties
implements JsonSerializable<ActiveDirectoryConfigProperties> {
    private String userName;
    private List<String> dns;
    private String smbServerName;
    private String organizationalUnit;
    private String site;
    private List<String> backupOperators;
    private List<String> administrators;
    private List<String> securityOperators;
    private ActiveDirectoryStatus activeDirectoryStatus;
    private ProvisioningState provisioningState;
    private String domain;
    private SecretPassword secretPassword;
    private static final ClientLogger LOGGER = new ClientLogger(ActiveDirectoryConfigProperties.class);

    public String userName() {
        return this.userName;
    }

    public ActiveDirectoryConfigProperties withUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public List<String> dns() {
        return this.dns;
    }

    public ActiveDirectoryConfigProperties withDns(List<String> dns) {
        this.dns = dns;
        return this;
    }

    public String smbServerName() {
        return this.smbServerName;
    }

    public ActiveDirectoryConfigProperties withSmbServerName(String smbServerName) {
        this.smbServerName = smbServerName;
        return this;
    }

    public String organizationalUnit() {
        return this.organizationalUnit;
    }

    public ActiveDirectoryConfigProperties withOrganizationalUnit(String organizationalUnit) {
        this.organizationalUnit = organizationalUnit;
        return this;
    }

    public String site() {
        return this.site;
    }

    public ActiveDirectoryConfigProperties withSite(String site) {
        this.site = site;
        return this;
    }

    public List<String> backupOperators() {
        return this.backupOperators;
    }

    public ActiveDirectoryConfigProperties withBackupOperators(List<String> backupOperators) {
        this.backupOperators = backupOperators;
        return this;
    }

    public List<String> administrators() {
        return this.administrators;
    }

    public ActiveDirectoryConfigProperties withAdministrators(List<String> administrators) {
        this.administrators = administrators;
        return this;
    }

    public List<String> securityOperators() {
        return this.securityOperators;
    }

    public ActiveDirectoryConfigProperties withSecurityOperators(List<String> securityOperators) {
        this.securityOperators = securityOperators;
        return this;
    }

    public ActiveDirectoryStatus activeDirectoryStatus() {
        return this.activeDirectoryStatus;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String domain() {
        return this.domain;
    }

    public ActiveDirectoryConfigProperties withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public SecretPassword secretPassword() {
        return this.secretPassword;
    }

    public ActiveDirectoryConfigProperties withSecretPassword(SecretPassword secretPassword) {
        this.secretPassword = secretPassword;
        return this;
    }

    public void validate() {
        if (this.domain() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property domain in model ActiveDirectoryConfigProperties"));
        }
        if (this.secretPassword() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property secretPassword in model ActiveDirectoryConfigProperties"));
        }
        this.secretPassword().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("domain", this.domain);
        jsonWriter.writeJsonField("secretPassword", (JsonSerializable)this.secretPassword);
        jsonWriter.writeStringField("userName", this.userName);
        jsonWriter.writeArrayField("dns", this.dns, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("smbServerName", this.smbServerName);
        jsonWriter.writeStringField("organizationalUnit", this.organizationalUnit);
        jsonWriter.writeStringField("site", this.site);
        jsonWriter.writeArrayField("backupOperators", this.backupOperators, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("administrators", this.administrators, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("securityOperators", this.securityOperators, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ActiveDirectoryConfigProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ActiveDirectoryConfigProperties)jsonReader.readObject(reader -> {
            ActiveDirectoryConfigProperties deserializedActiveDirectoryConfigProperties = new ActiveDirectoryConfigProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("domain".equals(fieldName)) {
                    deserializedActiveDirectoryConfigProperties.domain = reader.getString();
                    continue;
                }
                if ("secretPassword".equals(fieldName)) {
                    deserializedActiveDirectoryConfigProperties.secretPassword = SecretPassword.fromJson(reader);
                    continue;
                }
                if ("userName".equals(fieldName)) {
                    deserializedActiveDirectoryConfigProperties.userName = reader.getString();
                    continue;
                }
                if ("dns".equals(fieldName)) {
                    List dns;
                    deserializedActiveDirectoryConfigProperties.dns = dns = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("smbServerName".equals(fieldName)) {
                    deserializedActiveDirectoryConfigProperties.smbServerName = reader.getString();
                    continue;
                }
                if ("organizationalUnit".equals(fieldName)) {
                    deserializedActiveDirectoryConfigProperties.organizationalUnit = reader.getString();
                    continue;
                }
                if ("site".equals(fieldName)) {
                    deserializedActiveDirectoryConfigProperties.site = reader.getString();
                    continue;
                }
                if ("backupOperators".equals(fieldName)) {
                    List backupOperators;
                    deserializedActiveDirectoryConfigProperties.backupOperators = backupOperators = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("administrators".equals(fieldName)) {
                    List administrators;
                    deserializedActiveDirectoryConfigProperties.administrators = administrators = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("securityOperators".equals(fieldName)) {
                    List securityOperators;
                    deserializedActiveDirectoryConfigProperties.securityOperators = securityOperators = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("activeDirectoryStatus".equals(fieldName)) {
                    deserializedActiveDirectoryConfigProperties.activeDirectoryStatus = ActiveDirectoryStatus.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedActiveDirectoryConfigProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedActiveDirectoryConfigProperties;
        });
    }
}

