/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.fluent.models.ElasticVolumeInner;
import java.io.IOException;
import java.util.List;

public final class ElasticVolumeListResult
implements JsonSerializable<ElasticVolumeListResult> {
    private List<ElasticVolumeInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(ElasticVolumeListResult.class);

    private ElasticVolumeListResult() {
    }

    public List<ElasticVolumeInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model ElasticVolumeListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ElasticVolumeListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticVolumeListResult)jsonReader.readObject(reader -> {
            ElasticVolumeListResult deserializedElasticVolumeListResult = new ElasticVolumeListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedElasticVolumeListResult.value = value = reader.readArray(reader1 -> ElasticVolumeInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedElasticVolumeListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticVolumeListResult;
        });
    }
}

