/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.fluent.models.ElasticBackupVaultInner;
import java.io.IOException;
import java.util.List;

public final class ElasticBackupVaultListResult
implements JsonSerializable<ElasticBackupVaultListResult> {
    private List<ElasticBackupVaultInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(ElasticBackupVaultListResult.class);

    private ElasticBackupVaultListResult() {
    }

    public List<ElasticBackupVaultInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model ElasticBackupVaultListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ElasticBackupVaultListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticBackupVaultListResult)jsonReader.readObject(reader -> {
            ElasticBackupVaultListResult deserializedElasticBackupVaultListResult = new ElasticBackupVaultListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedElasticBackupVaultListResult.value = value = reader.readArray(reader1 -> ElasticBackupVaultInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedElasticBackupVaultListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticBackupVaultListResult;
        });
    }
}

