/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.fluent.models.ElasticBackupInner;
import java.io.IOException;
import java.util.List;

public final class ElasticBackupListResult
implements JsonSerializable<ElasticBackupListResult> {
    private List<ElasticBackupInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(ElasticBackupListResult.class);

    private ElasticBackupListResult() {
    }

    public List<ElasticBackupInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model ElasticBackupListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ElasticBackupListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticBackupListResult)jsonReader.readObject(reader -> {
            ElasticBackupListResult deserializedElasticBackupListResult = new ElasticBackupListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedElasticBackupListResult.value = value = reader.readArray(reader1 -> ElasticBackupInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedElasticBackupListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticBackupListResult;
        });
    }
}

