/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.netapp.fluent.models.ElasticAccountInner;
import java.io.IOException;
import java.util.List;

public final class ElasticAccountListResult
implements JsonSerializable<ElasticAccountListResult> {
    private List<ElasticAccountInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(ElasticAccountListResult.class);

    private ElasticAccountListResult() {
    }

    public List<ElasticAccountInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model ElasticAccountListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ElasticAccountListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticAccountListResult)jsonReader.readObject(reader -> {
            ElasticAccountListResult deserializedElasticAccountListResult = new ElasticAccountListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedElasticAccountListResult.value = value = reader.readArray(reader1 -> ElasticAccountInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedElasticAccountListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticAccountListResult;
        });
    }
}

