/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.SnapshotsClient;
import com.azure.resourcemanager.netapp.fluent.models.SnapshotInner;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.implementation.SnapshotImpl;
import com.azure.resourcemanager.netapp.models.Snapshot;
import com.azure.resourcemanager.netapp.models.SnapshotRestoreFiles;
import com.azure.resourcemanager.netapp.models.Snapshots;

public final class SnapshotsImpl
implements Snapshots {
    private static final ClientLogger LOGGER = new ClientLogger(SnapshotsImpl.class);
    private final SnapshotsClient innerClient;
    private final NetAppFilesManager serviceManager;

    public SnapshotsImpl(SnapshotsClient innerClient, NetAppFilesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Snapshot> getWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, Context context) {
        Response<SnapshotInner> inner = this.serviceClient().getWithResponse(resourceGroupName, accountName, poolName, volumeName, snapshotName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SnapshotImpl((SnapshotInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Snapshot get(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName) {
        SnapshotInner inner = this.serviceClient().get(resourceGroupName, accountName, poolName, volumeName, snapshotName);
        if (inner != null) {
            return new SnapshotImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName) {
        this.serviceClient().delete(resourceGroupName, accountName, poolName, volumeName, snapshotName);
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, Context context) {
        this.serviceClient().delete(resourceGroupName, accountName, poolName, volumeName, snapshotName, context);
    }

    @Override
    public PagedIterable<Snapshot> list(String resourceGroupName, String accountName, String poolName, String volumeName) {
        PagedIterable<SnapshotInner> inner = this.serviceClient().list(resourceGroupName, accountName, poolName, volumeName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SnapshotImpl((SnapshotInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Snapshot> list(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        PagedIterable<SnapshotInner> inner = this.serviceClient().list(resourceGroupName, accountName, poolName, volumeName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SnapshotImpl((SnapshotInner)((Object)inner1), this.manager()));
    }

    @Override
    public void restoreFiles(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, SnapshotRestoreFiles body) {
        this.serviceClient().restoreFiles(resourceGroupName, accountName, poolName, volumeName, snapshotName, body);
    }

    @Override
    public void restoreFiles(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, SnapshotRestoreFiles body, Context context) {
        this.serviceClient().restoreFiles(resourceGroupName, accountName, poolName, volumeName, snapshotName, body, context);
    }

    @Override
    public Snapshot getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "capacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'capacityPools'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "volumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumes'.", id)));
        }
        String snapshotName = ResourceManagerUtils.getValueFromIdByName(id, "snapshots");
        if (snapshotName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'snapshots'.", id)));
        }
        return (Snapshot)this.getWithResponse(resourceGroupName, accountName, poolName, volumeName, snapshotName, Context.NONE).getValue();
    }

    @Override
    public Response<Snapshot> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "capacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'capacityPools'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "volumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumes'.", id)));
        }
        String snapshotName = ResourceManagerUtils.getValueFromIdByName(id, "snapshots");
        if (snapshotName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'snapshots'.", id)));
        }
        return this.getWithResponse(resourceGroupName, accountName, poolName, volumeName, snapshotName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "capacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'capacityPools'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "volumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumes'.", id)));
        }
        String snapshotName = ResourceManagerUtils.getValueFromIdByName(id, "snapshots");
        if (snapshotName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'snapshots'.", id)));
        }
        this.delete(resourceGroupName, accountName, poolName, volumeName, snapshotName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "capacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'capacityPools'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "volumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'volumes'.", id)));
        }
        String snapshotName = ResourceManagerUtils.getValueFromIdByName(id, "snapshots");
        if (snapshotName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'snapshots'.", id)));
        }
        this.delete(resourceGroupName, accountName, poolName, volumeName, snapshotName, context);
    }

    private SnapshotsClient serviceClient() {
        return this.innerClient;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public SnapshotImpl define(String name) {
        return new SnapshotImpl(name, this.manager());
    }
}

