/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.SnapshotPoliciesClient;
import com.azure.resourcemanager.netapp.fluent.models.SnapshotPolicyInner;
import com.azure.resourcemanager.netapp.fluent.models.SnapshotPolicyVolumeListInner;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.implementation.SnapshotPolicyImpl;
import com.azure.resourcemanager.netapp.implementation.SnapshotPolicyVolumeListImpl;
import com.azure.resourcemanager.netapp.models.SnapshotPolicies;
import com.azure.resourcemanager.netapp.models.SnapshotPolicy;
import com.azure.resourcemanager.netapp.models.SnapshotPolicyVolumeList;

public final class SnapshotPoliciesImpl
implements SnapshotPolicies {
    private static final ClientLogger LOGGER = new ClientLogger(SnapshotPoliciesImpl.class);
    private final SnapshotPoliciesClient innerClient;
    private final NetAppFilesManager serviceManager;

    public SnapshotPoliciesImpl(SnapshotPoliciesClient innerClient, NetAppFilesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<SnapshotPolicy> getWithResponse(String resourceGroupName, String accountName, String snapshotPolicyName, Context context) {
        Response<SnapshotPolicyInner> inner = this.serviceClient().getWithResponse(resourceGroupName, accountName, snapshotPolicyName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SnapshotPolicyImpl((SnapshotPolicyInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SnapshotPolicy get(String resourceGroupName, String accountName, String snapshotPolicyName) {
        SnapshotPolicyInner inner = this.serviceClient().get(resourceGroupName, accountName, snapshotPolicyName);
        if (inner != null) {
            return new SnapshotPolicyImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String snapshotPolicyName) {
        this.serviceClient().delete(resourceGroupName, accountName, snapshotPolicyName);
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String snapshotPolicyName, Context context) {
        this.serviceClient().delete(resourceGroupName, accountName, snapshotPolicyName, context);
    }

    @Override
    public PagedIterable<SnapshotPolicy> list(String resourceGroupName, String accountName) {
        PagedIterable<SnapshotPolicyInner> inner = this.serviceClient().list(resourceGroupName, accountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SnapshotPolicyImpl((SnapshotPolicyInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SnapshotPolicy> list(String resourceGroupName, String accountName, Context context) {
        PagedIterable<SnapshotPolicyInner> inner = this.serviceClient().list(resourceGroupName, accountName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SnapshotPolicyImpl((SnapshotPolicyInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<SnapshotPolicyVolumeList> listVolumesWithResponse(String resourceGroupName, String accountName, String snapshotPolicyName, Context context) {
        Response<SnapshotPolicyVolumeListInner> inner = this.serviceClient().listVolumesWithResponse(resourceGroupName, accountName, snapshotPolicyName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SnapshotPolicyVolumeListImpl((SnapshotPolicyVolumeListInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public SnapshotPolicyVolumeList listVolumes(String resourceGroupName, String accountName, String snapshotPolicyName) {
        SnapshotPolicyVolumeListInner inner = this.serviceClient().listVolumes(resourceGroupName, accountName, snapshotPolicyName);
        if (inner != null) {
            return new SnapshotPolicyVolumeListImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public SnapshotPolicy getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String snapshotPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "snapshotPolicies");
        if (snapshotPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'snapshotPolicies'.", id)));
        }
        return (SnapshotPolicy)this.getWithResponse(resourceGroupName, accountName, snapshotPolicyName, Context.NONE).getValue();
    }

    @Override
    public Response<SnapshotPolicy> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String snapshotPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "snapshotPolicies");
        if (snapshotPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'snapshotPolicies'.", id)));
        }
        return this.getWithResponse(resourceGroupName, accountName, snapshotPolicyName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String snapshotPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "snapshotPolicies");
        if (snapshotPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'snapshotPolicies'.", id)));
        }
        this.delete(resourceGroupName, accountName, snapshotPolicyName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "netAppAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'netAppAccounts'.", id)));
        }
        String snapshotPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "snapshotPolicies");
        if (snapshotPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'snapshotPolicies'.", id)));
        }
        this.delete(resourceGroupName, accountName, snapshotPolicyName, context);
    }

    private SnapshotPoliciesClient serviceClient() {
        return this.innerClient;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public SnapshotPolicyImpl define(String name) {
        return new SnapshotPolicyImpl(name, this.manager());
    }
}

