/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.RansomwareReportsClient;
import com.azure.resourcemanager.netapp.fluent.models.RansomwareReportInner;
import com.azure.resourcemanager.netapp.implementation.RansomwareReportImpl;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.RansomwareReport;
import com.azure.resourcemanager.netapp.models.RansomwareReports;
import com.azure.resourcemanager.netapp.models.RansomwareSuspectsClearRequest;

public final class RansomwareReportsImpl
implements RansomwareReports {
    private static final ClientLogger LOGGER = new ClientLogger(RansomwareReportsImpl.class);
    private final RansomwareReportsClient innerClient;
    private final NetAppFilesManager serviceManager;

    public RansomwareReportsImpl(RansomwareReportsClient innerClient, NetAppFilesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<RansomwareReport> getWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, String ransomwareReportName, Context context) {
        Response<RansomwareReportInner> inner = this.serviceClient().getWithResponse(resourceGroupName, accountName, poolName, volumeName, ransomwareReportName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RansomwareReportImpl((RansomwareReportInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public RansomwareReport get(String resourceGroupName, String accountName, String poolName, String volumeName, String ransomwareReportName) {
        RansomwareReportInner inner = this.serviceClient().get(resourceGroupName, accountName, poolName, volumeName, ransomwareReportName);
        if (inner != null) {
            return new RansomwareReportImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<RansomwareReport> list(String resourceGroupName, String accountName, String poolName, String volumeName) {
        PagedIterable<RansomwareReportInner> inner = this.serviceClient().list(resourceGroupName, accountName, poolName, volumeName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RansomwareReportImpl((RansomwareReportInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<RansomwareReport> list(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        PagedIterable<RansomwareReportInner> inner = this.serviceClient().list(resourceGroupName, accountName, poolName, volumeName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RansomwareReportImpl((RansomwareReportInner)((Object)inner1), this.manager()));
    }

    @Override
    public void clearSuspects(String resourceGroupName, String accountName, String poolName, String volumeName, String ransomwareReportName, RansomwareSuspectsClearRequest body) {
        this.serviceClient().clearSuspects(resourceGroupName, accountName, poolName, volumeName, ransomwareReportName, body);
    }

    @Override
    public void clearSuspects(String resourceGroupName, String accountName, String poolName, String volumeName, String ransomwareReportName, RansomwareSuspectsClearRequest body, Context context) {
        this.serviceClient().clearSuspects(resourceGroupName, accountName, poolName, volumeName, ransomwareReportName, body, context);
    }

    private RansomwareReportsClient serviceClient() {
        return this.innerClient;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }
}

