/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.netapp.fluent.RansomwareReportsClient;
import com.azure.resourcemanager.netapp.fluent.models.RansomwareReportInner;
import com.azure.resourcemanager.netapp.implementation.NetAppManagementClientImpl;
import com.azure.resourcemanager.netapp.implementation.models.RansomwareReportsList;
import com.azure.resourcemanager.netapp.models.RansomwareSuspectsClearRequest;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class RansomwareReportsClientImpl
implements RansomwareReportsClient {
    private final RansomwareReportsService service;
    private final NetAppManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(RansomwareReportsClientImpl.class);

    RansomwareReportsClientImpl(NetAppManagementClientImpl client) {
        this.service = (RansomwareReportsService)RestProxy.create(RansomwareReportsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RansomwareReportInner>> getWithResponseAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String ransomwareReportName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (ransomwareReportName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ransomwareReportName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, ransomwareReportName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RansomwareReportInner> getAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String ransomwareReportName) {
        return this.getWithResponseAsync(resourceGroupName, accountName, poolName, volumeName, ransomwareReportName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RansomwareReportInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RansomwareReportInner> getWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, String ransomwareReportName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (ransomwareReportName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter ransomwareReportName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, ransomwareReportName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RansomwareReportInner get(String resourceGroupName, String accountName, String poolName, String volumeName, String ransomwareReportName) {
        return (RansomwareReportInner)((Object)this.getWithResponse(resourceGroupName, accountName, poolName, volumeName, ransomwareReportName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RansomwareReportInner>> listSinglePageAsync(String resourceGroupName, String accountName, String poolName, String volumeName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RansomwareReportsList)res.getValue()).value(), ((RansomwareReportsList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RansomwareReportInner> listAsync(String resourceGroupName, String accountName, String poolName, String volumeName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, accountName, poolName, volumeName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<RansomwareReportInner> listSinglePage(String resourceGroupName, String accountName, String poolName, String volumeName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<RansomwareReportsList> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RansomwareReportsList)res.getValue()).value(), ((RansomwareReportsList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<RansomwareReportInner> listSinglePage(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<RansomwareReportsList> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RansomwareReportsList)res.getValue()).value(), ((RansomwareReportsList)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RansomwareReportInner> list(String resourceGroupName, String accountName, String poolName, String volumeName) {
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, accountName, poolName, volumeName), nextLink -> this.listNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RansomwareReportInner> list(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, accountName, poolName, volumeName, context), nextLink -> this.listNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> clearSuspectsWithResponseAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String ransomwareReportName, RansomwareSuspectsClearRequest body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (ransomwareReportName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ransomwareReportName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        return FluxUtil.withContext(context -> this.service.clearSuspects(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, ransomwareReportName, "application/json", body, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> clearSuspectsWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, String ransomwareReportName, RansomwareSuspectsClearRequest body) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (ransomwareReportName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter ransomwareReportName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        return this.service.clearSuspectsSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, ransomwareReportName, "application/json", body, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> clearSuspectsWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, String ransomwareReportName, RansomwareSuspectsClearRequest body, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (poolName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter poolName is required and cannot be null."));
        }
        if (volumeName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter volumeName is required and cannot be null."));
        }
        if (ransomwareReportName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter ransomwareReportName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        return this.service.clearSuspectsSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, accountName, poolName, volumeName, ransomwareReportName, "application/json", body, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginClearSuspectsAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String ransomwareReportName, RansomwareSuspectsClearRequest body) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.clearSuspectsWithResponseAsync(resourceGroupName, accountName, poolName, volumeName, ransomwareReportName, body);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginClearSuspects(String resourceGroupName, String accountName, String poolName, String volumeName, String ransomwareReportName, RansomwareSuspectsClearRequest body) {
        Response<BinaryData> response = this.clearSuspectsWithResponse(resourceGroupName, accountName, poolName, volumeName, ransomwareReportName, body);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginClearSuspects(String resourceGroupName, String accountName, String poolName, String volumeName, String ransomwareReportName, RansomwareSuspectsClearRequest body, Context context) {
        Response<BinaryData> response = this.clearSuspectsWithResponse(resourceGroupName, accountName, poolName, volumeName, ransomwareReportName, body, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> clearSuspectsAsync(String resourceGroupName, String accountName, String poolName, String volumeName, String ransomwareReportName, RansomwareSuspectsClearRequest body) {
        return this.beginClearSuspectsAsync(resourceGroupName, accountName, poolName, volumeName, ransomwareReportName, body).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void clearSuspects(String resourceGroupName, String accountName, String poolName, String volumeName, String ransomwareReportName, RansomwareSuspectsClearRequest body) {
        this.beginClearSuspects(resourceGroupName, accountName, poolName, volumeName, ransomwareReportName, body).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void clearSuspects(String resourceGroupName, String accountName, String poolName, String volumeName, String ransomwareReportName, RansomwareSuspectsClearRequest body, Context context) {
        this.beginClearSuspects(resourceGroupName, accountName, poolName, volumeName, ransomwareReportName, body, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RansomwareReportInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RansomwareReportsList)res.getValue()).value(), ((RansomwareReportsList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<RansomwareReportInner> listNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<RansomwareReportsList> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RansomwareReportsList)res.getValue()).value(), ((RansomwareReportsList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<RansomwareReportInner> listNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<RansomwareReportsList> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RansomwareReportsList)res.getValue()).value(), ((RansomwareReportsList)res.getValue()).nextLink(), null);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="NetAppManagementClientRansomwareReports")
    public static interface RansomwareReportsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/ransomwareReports/{ransomwareReportName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RansomwareReportInner>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @PathParam(value="volumeName") String var7, @PathParam(value="ransomwareReportName") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/ransomwareReports/{ransomwareReportName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<RansomwareReportInner> getSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @PathParam(value="volumeName") String var7, @PathParam(value="ransomwareReportName") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/ransomwareReports")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RansomwareReportsList>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @PathParam(value="volumeName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/ransomwareReports")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<RansomwareReportsList> listSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @PathParam(value="volumeName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Accept: application/json;q=0.9"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/ransomwareReports/{ransomwareReportName}/clearSuspects")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> clearSuspects(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @PathParam(value="volumeName") String var7, @PathParam(value="ransomwareReportName") String var8, @HeaderParam(value="Content-Type") String var9, @BodyParam(value="application/json") RansomwareSuspectsClearRequest var10, Context var11);

        @Headers(value={"Accept: application/json;q=0.9"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/ransomwareReports/{ransomwareReportName}/clearSuspects")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> clearSuspectsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="accountName") String var5, @PathParam(value="poolName") String var6, @PathParam(value="volumeName") String var7, @PathParam(value="ransomwareReportName") String var8, @HeaderParam(value="Content-Type") String var9, @BodyParam(value="application/json") RansomwareSuspectsClearRequest var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RansomwareReportsList>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<RansomwareReportsList> listNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

