/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.NetAppResourceUsagesClient;
import com.azure.resourcemanager.netapp.fluent.models.UsageResultInner;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.implementation.UsageResultImpl;
import com.azure.resourcemanager.netapp.models.NetAppResourceUsages;
import com.azure.resourcemanager.netapp.models.UsageResult;

public final class NetAppResourceUsagesImpl
implements NetAppResourceUsages {
    private static final ClientLogger LOGGER = new ClientLogger(NetAppResourceUsagesImpl.class);
    private final NetAppResourceUsagesClient innerClient;
    private final NetAppFilesManager serviceManager;

    public NetAppResourceUsagesImpl(NetAppResourceUsagesClient innerClient, NetAppFilesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<UsageResult> list(String location) {
        PagedIterable<UsageResultInner> inner = this.serviceClient().list(location);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new UsageResultImpl((UsageResultInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<UsageResult> list(String location, Context context) {
        PagedIterable<UsageResultInner> inner = this.serviceClient().list(location, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new UsageResultImpl((UsageResultInner)inner1, this.manager()));
    }

    @Override
    public Response<UsageResult> getWithResponse(String location, String usageType, Context context) {
        Response<UsageResultInner> inner = this.serviceClient().getWithResponse(location, usageType, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new UsageResultImpl((UsageResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public UsageResult get(String location, String usageType) {
        UsageResultInner inner = this.serviceClient().get(location, usageType);
        if (inner != null) {
            return new UsageResultImpl(inner, this.manager());
        }
        return null;
    }

    private NetAppResourceUsagesClient serviceClient() {
        return this.innerClient;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }
}

