/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.ElasticVolumesClient;
import com.azure.resourcemanager.netapp.fluent.models.ElasticVolumeInner;
import com.azure.resourcemanager.netapp.implementation.ElasticVolumeImpl;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.ElasticVolume;
import com.azure.resourcemanager.netapp.models.ElasticVolumeRevert;
import com.azure.resourcemanager.netapp.models.ElasticVolumes;

public final class ElasticVolumesImpl
implements ElasticVolumes {
    private static final ClientLogger LOGGER = new ClientLogger(ElasticVolumesImpl.class);
    private final ElasticVolumesClient innerClient;
    private final NetAppFilesManager serviceManager;

    public ElasticVolumesImpl(ElasticVolumesClient innerClient, NetAppFilesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ElasticVolume> getWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        Response<ElasticVolumeInner> inner = this.serviceClient().getWithResponse(resourceGroupName, accountName, poolName, volumeName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ElasticVolumeImpl((ElasticVolumeInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ElasticVolume get(String resourceGroupName, String accountName, String poolName, String volumeName) {
        ElasticVolumeInner inner = this.serviceClient().get(resourceGroupName, accountName, poolName, volumeName);
        if (inner != null) {
            return new ElasticVolumeImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String poolName, String volumeName) {
        this.serviceClient().delete(resourceGroupName, accountName, poolName, volumeName);
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        this.serviceClient().delete(resourceGroupName, accountName, poolName, volumeName, context);
    }

    @Override
    public PagedIterable<ElasticVolume> listByElasticPool(String resourceGroupName, String accountName, String poolName) {
        PagedIterable<ElasticVolumeInner> inner = this.serviceClient().listByElasticPool(resourceGroupName, accountName, poolName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ElasticVolumeImpl((ElasticVolumeInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ElasticVolume> listByElasticPool(String resourceGroupName, String accountName, String poolName, Context context) {
        PagedIterable<ElasticVolumeInner> inner = this.serviceClient().listByElasticPool(resourceGroupName, accountName, poolName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ElasticVolumeImpl((ElasticVolumeInner)((Object)inner1), this.manager()));
    }

    @Override
    public ElasticVolume revert(String resourceGroupName, String accountName, String poolName, String volumeName, ElasticVolumeRevert body) {
        ElasticVolumeInner inner = this.serviceClient().revert(resourceGroupName, accountName, poolName, volumeName, body);
        if (inner != null) {
            return new ElasticVolumeImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ElasticVolume revert(String resourceGroupName, String accountName, String poolName, String volumeName, ElasticVolumeRevert body, Context context) {
        ElasticVolumeInner inner = this.serviceClient().revert(resourceGroupName, accountName, poolName, volumeName, body, context);
        if (inner != null) {
            return new ElasticVolumeImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ElasticVolume getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "elasticCapacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticCapacityPools'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "elasticVolumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticVolumes'.", id)));
        }
        return (ElasticVolume)this.getWithResponse(resourceGroupName, accountName, poolName, volumeName, Context.NONE).getValue();
    }

    @Override
    public Response<ElasticVolume> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "elasticCapacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticCapacityPools'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "elasticVolumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticVolumes'.", id)));
        }
        return this.getWithResponse(resourceGroupName, accountName, poolName, volumeName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "elasticCapacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticCapacityPools'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "elasticVolumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticVolumes'.", id)));
        }
        this.delete(resourceGroupName, accountName, poolName, volumeName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "elasticCapacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticCapacityPools'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "elasticVolumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticVolumes'.", id)));
        }
        this.delete(resourceGroupName, accountName, poolName, volumeName, context);
    }

    private ElasticVolumesClient serviceClient() {
        return this.innerClient;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public ElasticVolumeImpl define(String name) {
        return new ElasticVolumeImpl(name, this.manager());
    }
}

