/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.models.ElasticVolumeInner;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.ElasticVolume;
import com.azure.resourcemanager.netapp.models.ElasticVolumeProperties;
import com.azure.resourcemanager.netapp.models.ElasticVolumeRevert;
import com.azure.resourcemanager.netapp.models.ElasticVolumeUpdate;
import com.azure.resourcemanager.netapp.models.ElasticVolumeUpdateProperties;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ElasticVolumeImpl
implements ElasticVolume,
ElasticVolume.Definition,
ElasticVolume.Update {
    private ElasticVolumeInner innerObject;
    private final NetAppFilesManager serviceManager;
    private String resourceGroupName;
    private String accountName;
    private String poolName;
    private String volumeName;
    private ElasticVolumeUpdate updateBody;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ElasticVolumeProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public String eTag() {
        return this.innerModel().eTag();
    }

    @Override
    public List<String> zones() {
        List<String> inner = this.innerModel().zones();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ElasticVolumeInner innerModel() {
        return this.innerObject;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public ElasticVolumeImpl withExistingElasticCapacityPool(String resourceGroupName, String accountName, String poolName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        this.poolName = poolName;
        return this;
    }

    @Override
    public ElasticVolume create() {
        this.innerObject = this.serviceManager.serviceClient().getElasticVolumes().createOrUpdate(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ElasticVolume create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getElasticVolumes().createOrUpdate(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.innerModel(), context);
        return this;
    }

    ElasticVolumeImpl(String name, NetAppFilesManager serviceManager) {
        this.innerObject = new ElasticVolumeInner();
        this.serviceManager = serviceManager;
        this.volumeName = name;
    }

    @Override
    public ElasticVolumeImpl update() {
        this.updateBody = new ElasticVolumeUpdate();
        return this;
    }

    @Override
    public ElasticVolume apply() {
        this.innerObject = this.serviceManager.serviceClient().getElasticVolumes().update(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.updateBody, Context.NONE);
        return this;
    }

    @Override
    public ElasticVolume apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getElasticVolumes().update(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.updateBody, context);
        return this;
    }

    ElasticVolumeImpl(ElasticVolumeInner innerObject, NetAppFilesManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.accountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "elasticAccounts");
        this.poolName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "elasticCapacityPools");
        this.volumeName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "elasticVolumes");
    }

    @Override
    public ElasticVolume refresh() {
        this.innerObject = (ElasticVolumeInner)((Object)this.serviceManager.serviceClient().getElasticVolumes().getWithResponse(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ElasticVolume refresh(Context context) {
        this.innerObject = (ElasticVolumeInner)((Object)this.serviceManager.serviceClient().getElasticVolumes().getWithResponse(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, context).getValue());
        return this;
    }

    @Override
    public ElasticVolume revert(ElasticVolumeRevert body) {
        return this.serviceManager.elasticVolumes().revert(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, body);
    }

    @Override
    public ElasticVolume revert(ElasticVolumeRevert body, Context context) {
        return this.serviceManager.elasticVolumes().revert(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, body, context);
    }

    @Override
    public ElasticVolumeImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ElasticVolumeImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ElasticVolumeImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateBody.withTags(tags);
        return this;
    }

    @Override
    public ElasticVolumeImpl withProperties(ElasticVolumeProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public ElasticVolumeImpl withZones(List<String> zones) {
        this.innerModel().withZones(zones);
        return this;
    }

    @Override
    public ElasticVolumeImpl withProperties(ElasticVolumeUpdateProperties properties) {
        this.updateBody.withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

