/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.ElasticSnapshotsClient;
import com.azure.resourcemanager.netapp.fluent.models.ElasticSnapshotInner;
import com.azure.resourcemanager.netapp.implementation.ElasticSnapshotImpl;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.ElasticSnapshot;
import com.azure.resourcemanager.netapp.models.ElasticSnapshots;

public final class ElasticSnapshotsImpl
implements ElasticSnapshots {
    private static final ClientLogger LOGGER = new ClientLogger(ElasticSnapshotsImpl.class);
    private final ElasticSnapshotsClient innerClient;
    private final NetAppFilesManager serviceManager;

    public ElasticSnapshotsImpl(ElasticSnapshotsClient innerClient, NetAppFilesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ElasticSnapshot> getWithResponse(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, Context context) {
        Response<ElasticSnapshotInner> inner = this.serviceClient().getWithResponse(resourceGroupName, accountName, poolName, volumeName, snapshotName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ElasticSnapshotImpl((ElasticSnapshotInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ElasticSnapshot get(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName) {
        ElasticSnapshotInner inner = this.serviceClient().get(resourceGroupName, accountName, poolName, volumeName, snapshotName);
        if (inner != null) {
            return new ElasticSnapshotImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName) {
        this.serviceClient().delete(resourceGroupName, accountName, poolName, volumeName, snapshotName);
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String poolName, String volumeName, String snapshotName, Context context) {
        this.serviceClient().delete(resourceGroupName, accountName, poolName, volumeName, snapshotName, context);
    }

    @Override
    public PagedIterable<ElasticSnapshot> listByElasticVolume(String resourceGroupName, String accountName, String poolName, String volumeName) {
        PagedIterable<ElasticSnapshotInner> inner = this.serviceClient().listByElasticVolume(resourceGroupName, accountName, poolName, volumeName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ElasticSnapshotImpl((ElasticSnapshotInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ElasticSnapshot> listByElasticVolume(String resourceGroupName, String accountName, String poolName, String volumeName, Context context) {
        PagedIterable<ElasticSnapshotInner> inner = this.serviceClient().listByElasticVolume(resourceGroupName, accountName, poolName, volumeName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ElasticSnapshotImpl((ElasticSnapshotInner)((Object)inner1), this.manager()));
    }

    @Override
    public ElasticSnapshot getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "elasticCapacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticCapacityPools'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "elasticVolumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticVolumes'.", id)));
        }
        String snapshotName = ResourceManagerUtils.getValueFromIdByName(id, "elasticSnapshots");
        if (snapshotName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticSnapshots'.", id)));
        }
        return (ElasticSnapshot)this.getWithResponse(resourceGroupName, accountName, poolName, volumeName, snapshotName, Context.NONE).getValue();
    }

    @Override
    public Response<ElasticSnapshot> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "elasticCapacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticCapacityPools'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "elasticVolumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticVolumes'.", id)));
        }
        String snapshotName = ResourceManagerUtils.getValueFromIdByName(id, "elasticSnapshots");
        if (snapshotName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticSnapshots'.", id)));
        }
        return this.getWithResponse(resourceGroupName, accountName, poolName, volumeName, snapshotName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "elasticCapacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticCapacityPools'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "elasticVolumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticVolumes'.", id)));
        }
        String snapshotName = ResourceManagerUtils.getValueFromIdByName(id, "elasticSnapshots");
        if (snapshotName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticSnapshots'.", id)));
        }
        this.delete(resourceGroupName, accountName, poolName, volumeName, snapshotName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "elasticCapacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticCapacityPools'.", id)));
        }
        String volumeName = ResourceManagerUtils.getValueFromIdByName(id, "elasticVolumes");
        if (volumeName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticVolumes'.", id)));
        }
        String snapshotName = ResourceManagerUtils.getValueFromIdByName(id, "elasticSnapshots");
        if (snapshotName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticSnapshots'.", id)));
        }
        this.delete(resourceGroupName, accountName, poolName, volumeName, snapshotName, context);
    }

    private ElasticSnapshotsClient serviceClient() {
        return this.innerClient;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public ElasticSnapshotImpl define(String name) {
        return new ElasticSnapshotImpl(name, this.manager());
    }
}

