/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.models.ElasticSnapshotPolicyInner;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.ElasticSnapshotPolicy;
import com.azure.resourcemanager.netapp.models.ElasticSnapshotPolicyProperties;
import com.azure.resourcemanager.netapp.models.ElasticSnapshotPolicyUpdate;
import com.azure.resourcemanager.netapp.models.ElasticSnapshotPolicyUpdateProperties;
import java.util.Collections;
import java.util.Map;

public final class ElasticSnapshotPolicyImpl
implements ElasticSnapshotPolicy,
ElasticSnapshotPolicy.Definition,
ElasticSnapshotPolicy.Update {
    private ElasticSnapshotPolicyInner innerObject;
    private final NetAppFilesManager serviceManager;
    private String resourceGroupName;
    private String accountName;
    private String snapshotPolicyName;
    private ElasticSnapshotPolicyUpdate updateBody;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ElasticSnapshotPolicyProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public String eTag() {
        return this.innerModel().eTag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ElasticSnapshotPolicyInner innerModel() {
        return this.innerObject;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public ElasticSnapshotPolicyImpl withExistingElasticAccount(String resourceGroupName, String accountName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        return this;
    }

    @Override
    public ElasticSnapshotPolicy create() {
        this.innerObject = this.serviceManager.serviceClient().getElasticSnapshotPolicies().createOrUpdate(this.resourceGroupName, this.accountName, this.snapshotPolicyName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ElasticSnapshotPolicy create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getElasticSnapshotPolicies().createOrUpdate(this.resourceGroupName, this.accountName, this.snapshotPolicyName, this.innerModel(), context);
        return this;
    }

    ElasticSnapshotPolicyImpl(String name, NetAppFilesManager serviceManager) {
        this.innerObject = new ElasticSnapshotPolicyInner();
        this.serviceManager = serviceManager;
        this.snapshotPolicyName = name;
    }

    @Override
    public ElasticSnapshotPolicyImpl update() {
        this.updateBody = new ElasticSnapshotPolicyUpdate();
        return this;
    }

    @Override
    public ElasticSnapshotPolicy apply() {
        this.innerObject = this.serviceManager.serviceClient().getElasticSnapshotPolicies().update(this.resourceGroupName, this.accountName, this.snapshotPolicyName, this.updateBody, Context.NONE);
        return this;
    }

    @Override
    public ElasticSnapshotPolicy apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getElasticSnapshotPolicies().update(this.resourceGroupName, this.accountName, this.snapshotPolicyName, this.updateBody, context);
        return this;
    }

    ElasticSnapshotPolicyImpl(ElasticSnapshotPolicyInner innerObject, NetAppFilesManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.accountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "elasticAccounts");
        this.snapshotPolicyName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "elasticSnapshotPolicies");
    }

    @Override
    public ElasticSnapshotPolicy refresh() {
        this.innerObject = (ElasticSnapshotPolicyInner)((Object)this.serviceManager.serviceClient().getElasticSnapshotPolicies().getWithResponse(this.resourceGroupName, this.accountName, this.snapshotPolicyName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ElasticSnapshotPolicy refresh(Context context) {
        this.innerObject = (ElasticSnapshotPolicyInner)((Object)this.serviceManager.serviceClient().getElasticSnapshotPolicies().getWithResponse(this.resourceGroupName, this.accountName, this.snapshotPolicyName, context).getValue());
        return this;
    }

    @Override
    public ElasticSnapshotPolicyImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ElasticSnapshotPolicyImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ElasticSnapshotPolicyImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateBody.withTags(tags);
        return this;
    }

    @Override
    public ElasticSnapshotPolicyImpl withProperties(ElasticSnapshotPolicyProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public ElasticSnapshotPolicyImpl withProperties(ElasticSnapshotPolicyUpdateProperties properties) {
        this.updateBody.withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

