/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.ElasticSnapshotPoliciesClient;
import com.azure.resourcemanager.netapp.fluent.models.ElasticSnapshotPolicyInner;
import com.azure.resourcemanager.netapp.fluent.models.ElasticVolumeInner;
import com.azure.resourcemanager.netapp.implementation.ElasticSnapshotPolicyImpl;
import com.azure.resourcemanager.netapp.implementation.ElasticVolumeImpl;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.ElasticSnapshotPolicies;
import com.azure.resourcemanager.netapp.models.ElasticSnapshotPolicy;
import com.azure.resourcemanager.netapp.models.ElasticVolume;

public final class ElasticSnapshotPoliciesImpl
implements ElasticSnapshotPolicies {
    private static final ClientLogger LOGGER = new ClientLogger(ElasticSnapshotPoliciesImpl.class);
    private final ElasticSnapshotPoliciesClient innerClient;
    private final NetAppFilesManager serviceManager;

    public ElasticSnapshotPoliciesImpl(ElasticSnapshotPoliciesClient innerClient, NetAppFilesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ElasticSnapshotPolicy> getWithResponse(String resourceGroupName, String accountName, String snapshotPolicyName, Context context) {
        Response<ElasticSnapshotPolicyInner> inner = this.serviceClient().getWithResponse(resourceGroupName, accountName, snapshotPolicyName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ElasticSnapshotPolicyImpl((ElasticSnapshotPolicyInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ElasticSnapshotPolicy get(String resourceGroupName, String accountName, String snapshotPolicyName) {
        ElasticSnapshotPolicyInner inner = this.serviceClient().get(resourceGroupName, accountName, snapshotPolicyName);
        if (inner != null) {
            return new ElasticSnapshotPolicyImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String snapshotPolicyName) {
        this.serviceClient().delete(resourceGroupName, accountName, snapshotPolicyName);
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String snapshotPolicyName, Context context) {
        this.serviceClient().delete(resourceGroupName, accountName, snapshotPolicyName, context);
    }

    @Override
    public PagedIterable<ElasticSnapshotPolicy> listByElasticAccount(String resourceGroupName, String accountName) {
        PagedIterable<ElasticSnapshotPolicyInner> inner = this.serviceClient().listByElasticAccount(resourceGroupName, accountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ElasticSnapshotPolicyImpl((ElasticSnapshotPolicyInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ElasticSnapshotPolicy> listByElasticAccount(String resourceGroupName, String accountName, Context context) {
        PagedIterable<ElasticSnapshotPolicyInner> inner = this.serviceClient().listByElasticAccount(resourceGroupName, accountName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ElasticSnapshotPolicyImpl((ElasticSnapshotPolicyInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ElasticVolume> listElasticVolumes(String resourceGroupName, String accountName, String snapshotPolicyName) {
        PagedIterable<ElasticVolumeInner> inner = this.serviceClient().listElasticVolumes(resourceGroupName, accountName, snapshotPolicyName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ElasticVolumeImpl((ElasticVolumeInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ElasticVolume> listElasticVolumes(String resourceGroupName, String accountName, String snapshotPolicyName, Context context) {
        PagedIterable<ElasticVolumeInner> inner = this.serviceClient().listElasticVolumes(resourceGroupName, accountName, snapshotPolicyName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ElasticVolumeImpl((ElasticVolumeInner)((Object)inner1), this.manager()));
    }

    @Override
    public ElasticSnapshotPolicy getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        String snapshotPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "elasticSnapshotPolicies");
        if (snapshotPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticSnapshotPolicies'.", id)));
        }
        return (ElasticSnapshotPolicy)this.getWithResponse(resourceGroupName, accountName, snapshotPolicyName, Context.NONE).getValue();
    }

    @Override
    public Response<ElasticSnapshotPolicy> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        String snapshotPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "elasticSnapshotPolicies");
        if (snapshotPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticSnapshotPolicies'.", id)));
        }
        return this.getWithResponse(resourceGroupName, accountName, snapshotPolicyName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        String snapshotPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "elasticSnapshotPolicies");
        if (snapshotPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticSnapshotPolicies'.", id)));
        }
        this.delete(resourceGroupName, accountName, snapshotPolicyName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        String snapshotPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "elasticSnapshotPolicies");
        if (snapshotPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticSnapshotPolicies'.", id)));
        }
        this.delete(resourceGroupName, accountName, snapshotPolicyName, context);
    }

    private ElasticSnapshotPoliciesClient serviceClient() {
        return this.innerClient;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public ElasticSnapshotPolicyImpl define(String name) {
        return new ElasticSnapshotPolicyImpl(name, this.manager());
    }
}

