/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.models.ElasticSnapshotInner;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.ElasticSnapshot;
import com.azure.resourcemanager.netapp.models.ElasticSnapshotProperties;

public final class ElasticSnapshotImpl
implements ElasticSnapshot,
ElasticSnapshot.Definition,
ElasticSnapshot.Update {
    private ElasticSnapshotInner innerObject;
    private final NetAppFilesManager serviceManager;
    private String resourceGroupName;
    private String accountName;
    private String poolName;
    private String volumeName;
    private String snapshotName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public ElasticSnapshotProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ElasticSnapshotInner innerModel() {
        return this.innerObject;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public ElasticSnapshotImpl withExistingElasticVolume(String resourceGroupName, String accountName, String poolName, String volumeName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        this.poolName = poolName;
        this.volumeName = volumeName;
        return this;
    }

    @Override
    public ElasticSnapshot create() {
        this.innerObject = this.serviceManager.serviceClient().getElasticSnapshots().createOrUpdate(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.snapshotName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ElasticSnapshot create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getElasticSnapshots().createOrUpdate(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.snapshotName, this.innerModel(), context);
        return this;
    }

    ElasticSnapshotImpl(String name, NetAppFilesManager serviceManager) {
        this.innerObject = new ElasticSnapshotInner();
        this.serviceManager = serviceManager;
        this.snapshotName = name;
    }

    @Override
    public ElasticSnapshotImpl update() {
        return this;
    }

    @Override
    public ElasticSnapshot apply() {
        this.innerObject = this.serviceManager.serviceClient().getElasticSnapshots().createOrUpdate(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.snapshotName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ElasticSnapshot apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getElasticSnapshots().createOrUpdate(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.snapshotName, this.innerModel(), context);
        return this;
    }

    ElasticSnapshotImpl(ElasticSnapshotInner innerObject, NetAppFilesManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.accountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "elasticAccounts");
        this.poolName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "elasticCapacityPools");
        this.volumeName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "elasticVolumes");
        this.snapshotName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "elasticSnapshots");
    }

    @Override
    public ElasticSnapshot refresh() {
        this.innerObject = (ElasticSnapshotInner)((Object)this.serviceManager.serviceClient().getElasticSnapshots().getWithResponse(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.snapshotName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ElasticSnapshot refresh(Context context) {
        this.innerObject = (ElasticSnapshotInner)((Object)this.serviceManager.serviceClient().getElasticSnapshots().getWithResponse(this.resourceGroupName, this.accountName, this.poolName, this.volumeName, this.snapshotName, context).getValue());
        return this;
    }

    @Override
    public ElasticSnapshotImpl withProperties(ElasticSnapshotProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

