/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.ElasticCapacityPoolsClient;
import com.azure.resourcemanager.netapp.fluent.models.CheckElasticResourceAvailabilityResponseInner;
import com.azure.resourcemanager.netapp.fluent.models.ElasticCapacityPoolInner;
import com.azure.resourcemanager.netapp.implementation.CheckElasticResourceAvailabilityResponseImpl;
import com.azure.resourcemanager.netapp.implementation.ElasticCapacityPoolImpl;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.ChangeZoneRequest;
import com.azure.resourcemanager.netapp.models.CheckElasticResourceAvailabilityResponse;
import com.azure.resourcemanager.netapp.models.CheckElasticVolumeFilePathAvailabilityRequest;
import com.azure.resourcemanager.netapp.models.ElasticCapacityPool;
import com.azure.resourcemanager.netapp.models.ElasticCapacityPools;

public final class ElasticCapacityPoolsImpl
implements ElasticCapacityPools {
    private static final ClientLogger LOGGER = new ClientLogger(ElasticCapacityPoolsImpl.class);
    private final ElasticCapacityPoolsClient innerClient;
    private final NetAppFilesManager serviceManager;

    public ElasticCapacityPoolsImpl(ElasticCapacityPoolsClient innerClient, NetAppFilesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ElasticCapacityPool> getWithResponse(String resourceGroupName, String accountName, String poolName, Context context) {
        Response<ElasticCapacityPoolInner> inner = this.serviceClient().getWithResponse(resourceGroupName, accountName, poolName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ElasticCapacityPoolImpl((ElasticCapacityPoolInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ElasticCapacityPool get(String resourceGroupName, String accountName, String poolName) {
        ElasticCapacityPoolInner inner = this.serviceClient().get(resourceGroupName, accountName, poolName);
        if (inner != null) {
            return new ElasticCapacityPoolImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String poolName) {
        this.serviceClient().delete(resourceGroupName, accountName, poolName);
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String poolName, Context context) {
        this.serviceClient().delete(resourceGroupName, accountName, poolName, context);
    }

    @Override
    public PagedIterable<ElasticCapacityPool> listByElasticAccount(String resourceGroupName, String accountName) {
        PagedIterable<ElasticCapacityPoolInner> inner = this.serviceClient().listByElasticAccount(resourceGroupName, accountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ElasticCapacityPoolImpl((ElasticCapacityPoolInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ElasticCapacityPool> listByElasticAccount(String resourceGroupName, String accountName, Context context) {
        PagedIterable<ElasticCapacityPoolInner> inner = this.serviceClient().listByElasticAccount(resourceGroupName, accountName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ElasticCapacityPoolImpl((ElasticCapacityPoolInner)((Object)inner1), this.manager()));
    }

    @Override
    public ElasticCapacityPool changeZone(String resourceGroupName, String accountName, String poolName, ChangeZoneRequest body) {
        ElasticCapacityPoolInner inner = this.serviceClient().changeZone(resourceGroupName, accountName, poolName, body);
        if (inner != null) {
            return new ElasticCapacityPoolImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ElasticCapacityPool changeZone(String resourceGroupName, String accountName, String poolName, ChangeZoneRequest body, Context context) {
        ElasticCapacityPoolInner inner = this.serviceClient().changeZone(resourceGroupName, accountName, poolName, body, context);
        if (inner != null) {
            return new ElasticCapacityPoolImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<CheckElasticResourceAvailabilityResponse> checkVolumeFilePathAvailabilityWithResponse(String resourceGroupName, String accountName, String poolName, CheckElasticVolumeFilePathAvailabilityRequest body, Context context) {
        Response<CheckElasticResourceAvailabilityResponseInner> inner = this.serviceClient().checkVolumeFilePathAvailabilityWithResponse(resourceGroupName, accountName, poolName, body, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CheckElasticResourceAvailabilityResponseImpl((CheckElasticResourceAvailabilityResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public CheckElasticResourceAvailabilityResponse checkVolumeFilePathAvailability(String resourceGroupName, String accountName, String poolName, CheckElasticVolumeFilePathAvailabilityRequest body) {
        CheckElasticResourceAvailabilityResponseInner inner = this.serviceClient().checkVolumeFilePathAvailability(resourceGroupName, accountName, poolName, body);
        if (inner != null) {
            return new CheckElasticResourceAvailabilityResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ElasticCapacityPool getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "elasticCapacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticCapacityPools'.", id)));
        }
        return (ElasticCapacityPool)this.getWithResponse(resourceGroupName, accountName, poolName, Context.NONE).getValue();
    }

    @Override
    public Response<ElasticCapacityPool> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "elasticCapacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticCapacityPools'.", id)));
        }
        return this.getWithResponse(resourceGroupName, accountName, poolName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "elasticCapacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticCapacityPools'.", id)));
        }
        this.delete(resourceGroupName, accountName, poolName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        String poolName = ResourceManagerUtils.getValueFromIdByName(id, "elasticCapacityPools");
        if (poolName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticCapacityPools'.", id)));
        }
        this.delete(resourceGroupName, accountName, poolName, context);
    }

    private ElasticCapacityPoolsClient serviceClient() {
        return this.innerClient;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public ElasticCapacityPoolImpl define(String name) {
        return new ElasticCapacityPoolImpl(name, this.manager());
    }
}

