/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.models.ElasticCapacityPoolInner;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.ChangeZoneRequest;
import com.azure.resourcemanager.netapp.models.CheckElasticResourceAvailabilityResponse;
import com.azure.resourcemanager.netapp.models.CheckElasticVolumeFilePathAvailabilityRequest;
import com.azure.resourcemanager.netapp.models.ElasticCapacityPool;
import com.azure.resourcemanager.netapp.models.ElasticCapacityPoolProperties;
import com.azure.resourcemanager.netapp.models.ElasticCapacityPoolUpdate;
import com.azure.resourcemanager.netapp.models.ElasticCapacityPoolUpdateProperties;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ElasticCapacityPoolImpl
implements ElasticCapacityPool,
ElasticCapacityPool.Definition,
ElasticCapacityPool.Update {
    private ElasticCapacityPoolInner innerObject;
    private final NetAppFilesManager serviceManager;
    private String resourceGroupName;
    private String accountName;
    private String poolName;
    private ElasticCapacityPoolUpdate updateBody;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ElasticCapacityPoolProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public String eTag() {
        return this.innerModel().eTag();
    }

    @Override
    public List<String> zones() {
        List<String> inner = this.innerModel().zones();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ElasticCapacityPoolInner innerModel() {
        return this.innerObject;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public ElasticCapacityPoolImpl withExistingElasticAccount(String resourceGroupName, String accountName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        return this;
    }

    @Override
    public ElasticCapacityPool create() {
        this.innerObject = this.serviceManager.serviceClient().getElasticCapacityPools().createOrUpdate(this.resourceGroupName, this.accountName, this.poolName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ElasticCapacityPool create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getElasticCapacityPools().createOrUpdate(this.resourceGroupName, this.accountName, this.poolName, this.innerModel(), context);
        return this;
    }

    ElasticCapacityPoolImpl(String name, NetAppFilesManager serviceManager) {
        this.innerObject = new ElasticCapacityPoolInner();
        this.serviceManager = serviceManager;
        this.poolName = name;
    }

    @Override
    public ElasticCapacityPoolImpl update() {
        this.updateBody = new ElasticCapacityPoolUpdate();
        return this;
    }

    @Override
    public ElasticCapacityPool apply() {
        this.innerObject = this.serviceManager.serviceClient().getElasticCapacityPools().update(this.resourceGroupName, this.accountName, this.poolName, this.updateBody, Context.NONE);
        return this;
    }

    @Override
    public ElasticCapacityPool apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getElasticCapacityPools().update(this.resourceGroupName, this.accountName, this.poolName, this.updateBody, context);
        return this;
    }

    ElasticCapacityPoolImpl(ElasticCapacityPoolInner innerObject, NetAppFilesManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.accountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "elasticAccounts");
        this.poolName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "elasticCapacityPools");
    }

    @Override
    public ElasticCapacityPool refresh() {
        this.innerObject = (ElasticCapacityPoolInner)((Object)this.serviceManager.serviceClient().getElasticCapacityPools().getWithResponse(this.resourceGroupName, this.accountName, this.poolName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ElasticCapacityPool refresh(Context context) {
        this.innerObject = (ElasticCapacityPoolInner)((Object)this.serviceManager.serviceClient().getElasticCapacityPools().getWithResponse(this.resourceGroupName, this.accountName, this.poolName, context).getValue());
        return this;
    }

    @Override
    public ElasticCapacityPool changeZone(ChangeZoneRequest body) {
        return this.serviceManager.elasticCapacityPools().changeZone(this.resourceGroupName, this.accountName, this.poolName, body);
    }

    @Override
    public ElasticCapacityPool changeZone(ChangeZoneRequest body, Context context) {
        return this.serviceManager.elasticCapacityPools().changeZone(this.resourceGroupName, this.accountName, this.poolName, body, context);
    }

    @Override
    public Response<CheckElasticResourceAvailabilityResponse> checkVolumeFilePathAvailabilityWithResponse(CheckElasticVolumeFilePathAvailabilityRequest body, Context context) {
        return this.serviceManager.elasticCapacityPools().checkVolumeFilePathAvailabilityWithResponse(this.resourceGroupName, this.accountName, this.poolName, body, context);
    }

    @Override
    public CheckElasticResourceAvailabilityResponse checkVolumeFilePathAvailability(CheckElasticVolumeFilePathAvailabilityRequest body) {
        return this.serviceManager.elasticCapacityPools().checkVolumeFilePathAvailability(this.resourceGroupName, this.accountName, this.poolName, body);
    }

    @Override
    public ElasticCapacityPoolImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ElasticCapacityPoolImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ElasticCapacityPoolImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateBody.withTags(tags);
        return this;
    }

    @Override
    public ElasticCapacityPoolImpl withProperties(ElasticCapacityPoolProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public ElasticCapacityPoolImpl withZones(List<String> zones) {
        this.innerModel().withZones(zones);
        return this;
    }

    @Override
    public ElasticCapacityPoolImpl withProperties(ElasticCapacityPoolUpdateProperties properties) {
        this.updateBody.withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

