/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.ElasticBackupsClient;
import com.azure.resourcemanager.netapp.fluent.models.ElasticBackupInner;
import com.azure.resourcemanager.netapp.implementation.ElasticBackupImpl;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.ElasticBackup;
import com.azure.resourcemanager.netapp.models.ElasticBackups;

public final class ElasticBackupsImpl
implements ElasticBackups {
    private static final ClientLogger LOGGER = new ClientLogger(ElasticBackupsImpl.class);
    private final ElasticBackupsClient innerClient;
    private final NetAppFilesManager serviceManager;

    public ElasticBackupsImpl(ElasticBackupsClient innerClient, NetAppFilesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ElasticBackup> getWithResponse(String resourceGroupName, String accountName, String backupVaultName, String backupName, Context context) {
        Response<ElasticBackupInner> inner = this.serviceClient().getWithResponse(resourceGroupName, accountName, backupVaultName, backupName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ElasticBackupImpl((ElasticBackupInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ElasticBackup get(String resourceGroupName, String accountName, String backupVaultName, String backupName) {
        ElasticBackupInner inner = this.serviceClient().get(resourceGroupName, accountName, backupVaultName, backupName);
        if (inner != null) {
            return new ElasticBackupImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String backupVaultName, String backupName) {
        this.serviceClient().delete(resourceGroupName, accountName, backupVaultName, backupName);
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String backupVaultName, String backupName, Context context) {
        this.serviceClient().delete(resourceGroupName, accountName, backupVaultName, backupName, context);
    }

    @Override
    public PagedIterable<ElasticBackup> listByVault(String resourceGroupName, String accountName, String backupVaultName) {
        PagedIterable<ElasticBackupInner> inner = this.serviceClient().listByVault(resourceGroupName, accountName, backupVaultName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ElasticBackupImpl((ElasticBackupInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ElasticBackup> listByVault(String resourceGroupName, String accountName, String backupVaultName, Context context) {
        PagedIterable<ElasticBackupInner> inner = this.serviceClient().listByVault(resourceGroupName, accountName, backupVaultName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ElasticBackupImpl((ElasticBackupInner)((Object)inner1), this.manager()));
    }

    @Override
    public ElasticBackup getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        String backupVaultName = ResourceManagerUtils.getValueFromIdByName(id, "elasticBackupVaults");
        if (backupVaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticBackupVaults'.", id)));
        }
        String backupName = ResourceManagerUtils.getValueFromIdByName(id, "elasticBackups");
        if (backupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticBackups'.", id)));
        }
        return (ElasticBackup)this.getWithResponse(resourceGroupName, accountName, backupVaultName, backupName, Context.NONE).getValue();
    }

    @Override
    public Response<ElasticBackup> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        String backupVaultName = ResourceManagerUtils.getValueFromIdByName(id, "elasticBackupVaults");
        if (backupVaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticBackupVaults'.", id)));
        }
        String backupName = ResourceManagerUtils.getValueFromIdByName(id, "elasticBackups");
        if (backupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticBackups'.", id)));
        }
        return this.getWithResponse(resourceGroupName, accountName, backupVaultName, backupName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        String backupVaultName = ResourceManagerUtils.getValueFromIdByName(id, "elasticBackupVaults");
        if (backupVaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticBackupVaults'.", id)));
        }
        String backupName = ResourceManagerUtils.getValueFromIdByName(id, "elasticBackups");
        if (backupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticBackups'.", id)));
        }
        this.delete(resourceGroupName, accountName, backupVaultName, backupName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        String backupVaultName = ResourceManagerUtils.getValueFromIdByName(id, "elasticBackupVaults");
        if (backupVaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticBackupVaults'.", id)));
        }
        String backupName = ResourceManagerUtils.getValueFromIdByName(id, "elasticBackups");
        if (backupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticBackups'.", id)));
        }
        this.delete(resourceGroupName, accountName, backupVaultName, backupName, context);
    }

    private ElasticBackupsClient serviceClient() {
        return this.innerClient;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public ElasticBackupImpl define(String name) {
        return new ElasticBackupImpl(name, this.manager());
    }
}

