/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.ElasticBackupVaultsClient;
import com.azure.resourcemanager.netapp.fluent.models.ElasticBackupVaultInner;
import com.azure.resourcemanager.netapp.implementation.ElasticBackupVaultImpl;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.ElasticBackupVault;
import com.azure.resourcemanager.netapp.models.ElasticBackupVaults;

public final class ElasticBackupVaultsImpl
implements ElasticBackupVaults {
    private static final ClientLogger LOGGER = new ClientLogger(ElasticBackupVaultsImpl.class);
    private final ElasticBackupVaultsClient innerClient;
    private final NetAppFilesManager serviceManager;

    public ElasticBackupVaultsImpl(ElasticBackupVaultsClient innerClient, NetAppFilesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ElasticBackupVault> getWithResponse(String resourceGroupName, String accountName, String backupVaultName, Context context) {
        Response<ElasticBackupVaultInner> inner = this.serviceClient().getWithResponse(resourceGroupName, accountName, backupVaultName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ElasticBackupVaultImpl((ElasticBackupVaultInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ElasticBackupVault get(String resourceGroupName, String accountName, String backupVaultName) {
        ElasticBackupVaultInner inner = this.serviceClient().get(resourceGroupName, accountName, backupVaultName);
        if (inner != null) {
            return new ElasticBackupVaultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String backupVaultName) {
        this.serviceClient().delete(resourceGroupName, accountName, backupVaultName);
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String backupVaultName, Context context) {
        this.serviceClient().delete(resourceGroupName, accountName, backupVaultName, context);
    }

    @Override
    public PagedIterable<ElasticBackupVault> listByElasticAccount(String resourceGroupName, String accountName) {
        PagedIterable<ElasticBackupVaultInner> inner = this.serviceClient().listByElasticAccount(resourceGroupName, accountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ElasticBackupVaultImpl((ElasticBackupVaultInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ElasticBackupVault> listByElasticAccount(String resourceGroupName, String accountName, Context context) {
        PagedIterable<ElasticBackupVaultInner> inner = this.serviceClient().listByElasticAccount(resourceGroupName, accountName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ElasticBackupVaultImpl((ElasticBackupVaultInner)((Object)inner1), this.manager()));
    }

    @Override
    public ElasticBackupVault getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        String backupVaultName = ResourceManagerUtils.getValueFromIdByName(id, "elasticBackupVaults");
        if (backupVaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticBackupVaults'.", id)));
        }
        return (ElasticBackupVault)this.getWithResponse(resourceGroupName, accountName, backupVaultName, Context.NONE).getValue();
    }

    @Override
    public Response<ElasticBackupVault> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        String backupVaultName = ResourceManagerUtils.getValueFromIdByName(id, "elasticBackupVaults");
        if (backupVaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticBackupVaults'.", id)));
        }
        return this.getWithResponse(resourceGroupName, accountName, backupVaultName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        String backupVaultName = ResourceManagerUtils.getValueFromIdByName(id, "elasticBackupVaults");
        if (backupVaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticBackupVaults'.", id)));
        }
        this.delete(resourceGroupName, accountName, backupVaultName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        String backupVaultName = ResourceManagerUtils.getValueFromIdByName(id, "elasticBackupVaults");
        if (backupVaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticBackupVaults'.", id)));
        }
        this.delete(resourceGroupName, accountName, backupVaultName, context);
    }

    private ElasticBackupVaultsClient serviceClient() {
        return this.innerClient;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public ElasticBackupVaultImpl define(String name) {
        return new ElasticBackupVaultImpl(name, this.manager());
    }
}

