/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.models.ElasticBackupVaultInner;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.ElasticBackupVault;
import com.azure.resourcemanager.netapp.models.ElasticBackupVaultProperties;
import com.azure.resourcemanager.netapp.models.ElasticBackupVaultUpdate;
import java.util.Collections;
import java.util.Map;

public final class ElasticBackupVaultImpl
implements ElasticBackupVault,
ElasticBackupVault.Definition,
ElasticBackupVault.Update {
    private ElasticBackupVaultInner innerObject;
    private final NetAppFilesManager serviceManager;
    private String resourceGroupName;
    private String accountName;
    private String backupVaultName;
    private ElasticBackupVaultUpdate updateBody;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ElasticBackupVaultProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public String eTag() {
        return this.innerModel().eTag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ElasticBackupVaultInner innerModel() {
        return this.innerObject;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public ElasticBackupVaultImpl withExistingElasticAccount(String resourceGroupName, String accountName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        return this;
    }

    @Override
    public ElasticBackupVault create() {
        this.innerObject = this.serviceManager.serviceClient().getElasticBackupVaults().createOrUpdate(this.resourceGroupName, this.accountName, this.backupVaultName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ElasticBackupVault create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getElasticBackupVaults().createOrUpdate(this.resourceGroupName, this.accountName, this.backupVaultName, this.innerModel(), context);
        return this;
    }

    ElasticBackupVaultImpl(String name, NetAppFilesManager serviceManager) {
        this.innerObject = new ElasticBackupVaultInner();
        this.serviceManager = serviceManager;
        this.backupVaultName = name;
    }

    @Override
    public ElasticBackupVaultImpl update() {
        this.updateBody = new ElasticBackupVaultUpdate();
        return this;
    }

    @Override
    public ElasticBackupVault apply() {
        this.innerObject = this.serviceManager.serviceClient().getElasticBackupVaults().update(this.resourceGroupName, this.accountName, this.backupVaultName, this.updateBody, Context.NONE);
        return this;
    }

    @Override
    public ElasticBackupVault apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getElasticBackupVaults().update(this.resourceGroupName, this.accountName, this.backupVaultName, this.updateBody, context);
        return this;
    }

    ElasticBackupVaultImpl(ElasticBackupVaultInner innerObject, NetAppFilesManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.accountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "elasticAccounts");
        this.backupVaultName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "elasticBackupVaults");
    }

    @Override
    public ElasticBackupVault refresh() {
        this.innerObject = (ElasticBackupVaultInner)((Object)this.serviceManager.serviceClient().getElasticBackupVaults().getWithResponse(this.resourceGroupName, this.accountName, this.backupVaultName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ElasticBackupVault refresh(Context context) {
        this.innerObject = (ElasticBackupVaultInner)((Object)this.serviceManager.serviceClient().getElasticBackupVaults().getWithResponse(this.resourceGroupName, this.accountName, this.backupVaultName, context).getValue());
        return this;
    }

    @Override
    public ElasticBackupVaultImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ElasticBackupVaultImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ElasticBackupVaultImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateBody.withTags(tags);
        return this;
    }

    @Override
    public ElasticBackupVaultImpl withProperties(ElasticBackupVaultProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

