/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.models.ElasticBackupPolicyInner;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.ElasticBackupPolicy;
import com.azure.resourcemanager.netapp.models.ElasticBackupPolicyProperties;
import com.azure.resourcemanager.netapp.models.ElasticBackupPolicyUpdate;
import com.azure.resourcemanager.netapp.models.ElasticBackupPolicyUpdateProperties;
import java.util.Collections;
import java.util.Map;

public final class ElasticBackupPolicyImpl
implements ElasticBackupPolicy,
ElasticBackupPolicy.Definition,
ElasticBackupPolicy.Update {
    private ElasticBackupPolicyInner innerObject;
    private final NetAppFilesManager serviceManager;
    private String resourceGroupName;
    private String accountName;
    private String backupPolicyName;
    private ElasticBackupPolicyUpdate updateBody;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ElasticBackupPolicyProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public String eTag() {
        return this.innerModel().eTag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ElasticBackupPolicyInner innerModel() {
        return this.innerObject;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public ElasticBackupPolicyImpl withExistingElasticAccount(String resourceGroupName, String accountName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        return this;
    }

    @Override
    public ElasticBackupPolicy create() {
        this.innerObject = this.serviceManager.serviceClient().getElasticBackupPolicies().createOrUpdate(this.resourceGroupName, this.accountName, this.backupPolicyName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ElasticBackupPolicy create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getElasticBackupPolicies().createOrUpdate(this.resourceGroupName, this.accountName, this.backupPolicyName, this.innerModel(), context);
        return this;
    }

    ElasticBackupPolicyImpl(String name, NetAppFilesManager serviceManager) {
        this.innerObject = new ElasticBackupPolicyInner();
        this.serviceManager = serviceManager;
        this.backupPolicyName = name;
    }

    @Override
    public ElasticBackupPolicyImpl update() {
        this.updateBody = new ElasticBackupPolicyUpdate();
        return this;
    }

    @Override
    public ElasticBackupPolicy apply() {
        this.innerObject = this.serviceManager.serviceClient().getElasticBackupPolicies().update(this.resourceGroupName, this.accountName, this.backupPolicyName, this.updateBody, Context.NONE);
        return this;
    }

    @Override
    public ElasticBackupPolicy apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getElasticBackupPolicies().update(this.resourceGroupName, this.accountName, this.backupPolicyName, this.updateBody, context);
        return this;
    }

    ElasticBackupPolicyImpl(ElasticBackupPolicyInner innerObject, NetAppFilesManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.accountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "elasticAccounts");
        this.backupPolicyName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "elasticBackupPolicies");
    }

    @Override
    public ElasticBackupPolicy refresh() {
        this.innerObject = (ElasticBackupPolicyInner)((Object)this.serviceManager.serviceClient().getElasticBackupPolicies().getWithResponse(this.resourceGroupName, this.accountName, this.backupPolicyName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ElasticBackupPolicy refresh(Context context) {
        this.innerObject = (ElasticBackupPolicyInner)((Object)this.serviceManager.serviceClient().getElasticBackupPolicies().getWithResponse(this.resourceGroupName, this.accountName, this.backupPolicyName, context).getValue());
        return this;
    }

    @Override
    public ElasticBackupPolicyImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ElasticBackupPolicyImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ElasticBackupPolicyImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateBody.withTags(tags);
        return this;
    }

    @Override
    public ElasticBackupPolicyImpl withProperties(ElasticBackupPolicyProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public ElasticBackupPolicyImpl withProperties(ElasticBackupPolicyUpdateProperties properties) {
        this.updateBody.withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

