/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.ElasticBackupPoliciesClient;
import com.azure.resourcemanager.netapp.fluent.models.ElasticBackupPolicyInner;
import com.azure.resourcemanager.netapp.implementation.ElasticBackupPolicyImpl;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.ElasticBackupPolicies;
import com.azure.resourcemanager.netapp.models.ElasticBackupPolicy;

public final class ElasticBackupPoliciesImpl
implements ElasticBackupPolicies {
    private static final ClientLogger LOGGER = new ClientLogger(ElasticBackupPoliciesImpl.class);
    private final ElasticBackupPoliciesClient innerClient;
    private final NetAppFilesManager serviceManager;

    public ElasticBackupPoliciesImpl(ElasticBackupPoliciesClient innerClient, NetAppFilesManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ElasticBackupPolicy> getWithResponse(String resourceGroupName, String accountName, String backupPolicyName, Context context) {
        Response<ElasticBackupPolicyInner> inner = this.serviceClient().getWithResponse(resourceGroupName, accountName, backupPolicyName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ElasticBackupPolicyImpl((ElasticBackupPolicyInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ElasticBackupPolicy get(String resourceGroupName, String accountName, String backupPolicyName) {
        ElasticBackupPolicyInner inner = this.serviceClient().get(resourceGroupName, accountName, backupPolicyName);
        if (inner != null) {
            return new ElasticBackupPolicyImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String backupPolicyName) {
        this.serviceClient().delete(resourceGroupName, accountName, backupPolicyName);
    }

    @Override
    public void delete(String resourceGroupName, String accountName, String backupPolicyName, Context context) {
        this.serviceClient().delete(resourceGroupName, accountName, backupPolicyName, context);
    }

    @Override
    public PagedIterable<ElasticBackupPolicy> listByElasticAccount(String resourceGroupName, String accountName) {
        PagedIterable<ElasticBackupPolicyInner> inner = this.serviceClient().listByElasticAccount(resourceGroupName, accountName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ElasticBackupPolicyImpl((ElasticBackupPolicyInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ElasticBackupPolicy> listByElasticAccount(String resourceGroupName, String accountName, Context context) {
        PagedIterable<ElasticBackupPolicyInner> inner = this.serviceClient().listByElasticAccount(resourceGroupName, accountName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ElasticBackupPolicyImpl((ElasticBackupPolicyInner)((Object)inner1), this.manager()));
    }

    @Override
    public ElasticBackupPolicy getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        String backupPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "elasticBackupPolicies");
        if (backupPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticBackupPolicies'.", id)));
        }
        return (ElasticBackupPolicy)this.getWithResponse(resourceGroupName, accountName, backupPolicyName, Context.NONE).getValue();
    }

    @Override
    public Response<ElasticBackupPolicy> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        String backupPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "elasticBackupPolicies");
        if (backupPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticBackupPolicies'.", id)));
        }
        return this.getWithResponse(resourceGroupName, accountName, backupPolicyName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        String backupPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "elasticBackupPolicies");
        if (backupPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticBackupPolicies'.", id)));
        }
        this.delete(resourceGroupName, accountName, backupPolicyName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String accountName = ResourceManagerUtils.getValueFromIdByName(id, "elasticAccounts");
        if (accountName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticAccounts'.", id)));
        }
        String backupPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "elasticBackupPolicies");
        if (backupPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'elasticBackupPolicies'.", id)));
        }
        this.delete(resourceGroupName, accountName, backupPolicyName, context);
    }

    private ElasticBackupPoliciesClient serviceClient() {
        return this.innerClient;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public ElasticBackupPolicyImpl define(String name) {
        return new ElasticBackupPolicyImpl(name, this.manager());
    }
}

