/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.netapp.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.netapp.NetAppFilesManager;
import com.azure.resourcemanager.netapp.fluent.models.ElasticBackupInner;
import com.azure.resourcemanager.netapp.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.netapp.models.ElasticBackup;
import com.azure.resourcemanager.netapp.models.ElasticBackupProperties;

public final class ElasticBackupImpl
implements ElasticBackup,
ElasticBackup.Definition,
ElasticBackup.Update {
    private ElasticBackupInner innerObject;
    private final NetAppFilesManager serviceManager;
    private String resourceGroupName;
    private String accountName;
    private String backupVaultName;
    private String backupName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public ElasticBackupProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ElasticBackupInner innerModel() {
        return this.innerObject;
    }

    private NetAppFilesManager manager() {
        return this.serviceManager;
    }

    @Override
    public ElasticBackupImpl withExistingElasticBackupVault(String resourceGroupName, String accountName, String backupVaultName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        this.backupVaultName = backupVaultName;
        return this;
    }

    @Override
    public ElasticBackup create() {
        this.innerObject = this.serviceManager.serviceClient().getElasticBackups().createOrUpdate(this.resourceGroupName, this.accountName, this.backupVaultName, this.backupName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ElasticBackup create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getElasticBackups().createOrUpdate(this.resourceGroupName, this.accountName, this.backupVaultName, this.backupName, this.innerModel(), context);
        return this;
    }

    ElasticBackupImpl(String name, NetAppFilesManager serviceManager) {
        this.innerObject = new ElasticBackupInner();
        this.serviceManager = serviceManager;
        this.backupName = name;
    }

    @Override
    public ElasticBackupImpl update() {
        return this;
    }

    @Override
    public ElasticBackup apply() {
        this.innerObject = this.serviceManager.serviceClient().getElasticBackups().update(this.resourceGroupName, this.accountName, this.backupVaultName, this.backupName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ElasticBackup apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getElasticBackups().update(this.resourceGroupName, this.accountName, this.backupVaultName, this.backupName, this.innerModel(), context);
        return this;
    }

    ElasticBackupImpl(ElasticBackupInner innerObject, NetAppFilesManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.accountName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "elasticAccounts");
        this.backupVaultName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "elasticBackupVaults");
        this.backupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "elasticBackups");
    }

    @Override
    public ElasticBackup refresh() {
        this.innerObject = (ElasticBackupInner)((Object)this.serviceManager.serviceClient().getElasticBackups().getWithResponse(this.resourceGroupName, this.accountName, this.backupVaultName, this.backupName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ElasticBackup refresh(Context context) {
        this.innerObject = (ElasticBackupInner)((Object)this.serviceManager.serviceClient().getElasticBackups().getWithResponse(this.resourceGroupName, this.accountName, this.backupVaultName, this.backupName, context).getValue());
        return this;
    }

    @Override
    public ElasticBackupImpl withProperties(ElasticBackupProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

